package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteLicenseManagerReportGeneratorRequest(licenseManagerReportGeneratorArn: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest = {
    import DeleteLicenseManagerReportGeneratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest.builder().licenseManagerReportGeneratorArn(licenseManagerReportGeneratorArn: java.lang.String).build()
  }
  def asReadOnly: DeleteLicenseManagerReportGeneratorRequest.ReadOnly = DeleteLicenseManagerReportGeneratorRequest.wrap(buildAwsValue())
}
object DeleteLicenseManagerReportGeneratorRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteLicenseManagerReportGeneratorRequest = DeleteLicenseManagerReportGeneratorRequest(licenseManagerReportGeneratorArnValue)
    def licenseManagerReportGeneratorArnValue: String
    def licenseManagerReportGeneratorArn: ZIO[Any, Nothing, String] = ZIO.succeed(licenseManagerReportGeneratorArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest) extends DeleteLicenseManagerReportGeneratorRequest.ReadOnly { override def licenseManagerReportGeneratorArnValue: String = impl.licenseManagerReportGeneratorArn(): String }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest): ReadOnly = new Wrapper(impl)
}