package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DatetimeRange(begin: primitives.ISO8601DateTime, end: scala.Option[primitives.ISO8601DateTime] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.DatetimeRange = {
    import DatetimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DatetimeRange.builder().begin(begin: java.lang.String).optionallyWith(end.map(value => value: java.lang.String))(_.end).build()
  }
  def asReadOnly: DatetimeRange.ReadOnly = DatetimeRange.wrap(buildAwsValue())
}
object DatetimeRange {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.DatetimeRange] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DatetimeRange = DatetimeRange(beginValue, endValue.map(value => value))
    def beginValue: primitives.ISO8601DateTime
    def endValue: scala.Option[primitives.ISO8601DateTime]
    def begin: ZIO[Any, Nothing, primitives.ISO8601DateTime] = ZIO.succeed(beginValue)
    def end: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ISO8601DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("end", endValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.DatetimeRange) extends DatetimeRange.ReadOnly {
    override def beginValue: primitives.ISO8601DateTime = impl.begin(): primitives.ISO8601DateTime
    override def endValue: scala.Option[primitives.ISO8601DateTime] = scala.Option(impl.end()).map(value => value: primitives.ISO8601DateTime)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.DatetimeRange): ReadOnly = new Wrapper(impl)
}