package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLicenseRequest(licenseName: String, productName: String, productSKU: String, issuer: Issuer, homeRegion: String, validity: DatetimeRange, entitlements: Iterable[Entitlement], beneficiary: String, consumptionConfiguration: ConsumptionConfiguration, licenseMetadata: scala.Option[Iterable[Metadata]] = None, clientToken: primitives.ClientToken) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest = {
    import CreateLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest.builder().licenseName(licenseName: java.lang.String).productName(productName: java.lang.String).productSKU(productSKU: java.lang.String).issuer(issuer.buildAwsValue()).homeRegion(homeRegion: java.lang.String).validity(validity.buildAwsValue()).entitlements(entitlements.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).beneficiary(beneficiary: java.lang.String).consumptionConfiguration(consumptionConfiguration.buildAwsValue()).optionallyWith(licenseMetadata.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenseMetadata).clientToken(clientToken: java.lang.String).build()
  }
  def asReadOnly: CreateLicenseRequest.ReadOnly = CreateLicenseRequest.wrap(buildAwsValue())
}
object CreateLicenseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLicenseRequest = CreateLicenseRequest(licenseNameValue, productNameValue, productSKUValue, issuerValue.editable, homeRegionValue, validityValue.editable, entitlementsValue.map { item => 
      item.editable
    }, beneficiaryValue, consumptionConfigurationValue.editable, licenseMetadataValue.map(value => value.map { item => 
      item.editable
    }), clientTokenValue)
    def licenseNameValue: String
    def productNameValue: String
    def productSKUValue: String
    def issuerValue: Issuer.ReadOnly
    def homeRegionValue: String
    def validityValue: DatetimeRange.ReadOnly
    def entitlementsValue: List[Entitlement.ReadOnly]
    def beneficiaryValue: String
    def consumptionConfigurationValue: ConsumptionConfiguration.ReadOnly
    def licenseMetadataValue: scala.Option[List[Metadata.ReadOnly]]
    def clientTokenValue: primitives.ClientToken
    def licenseName: ZIO[Any, Nothing, String] = ZIO.succeed(licenseNameValue)
    def productName: ZIO[Any, Nothing, String] = ZIO.succeed(productNameValue)
    def productSKU: ZIO[Any, Nothing, String] = ZIO.succeed(productSKUValue)
    def issuer: ZIO[Any, Nothing, Issuer.ReadOnly] = ZIO.succeed(issuerValue)
    def homeRegion: ZIO[Any, Nothing, String] = ZIO.succeed(homeRegionValue)
    def validity: ZIO[Any, Nothing, DatetimeRange.ReadOnly] = ZIO.succeed(validityValue)
    def entitlements: ZIO[Any, Nothing, List[Entitlement.ReadOnly]] = ZIO.succeed(entitlementsValue)
    def beneficiary: ZIO[Any, Nothing, String] = ZIO.succeed(beneficiaryValue)
    def consumptionConfiguration: ZIO[Any, Nothing, ConsumptionConfiguration.ReadOnly] = ZIO.succeed(consumptionConfigurationValue)
    def licenseMetadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Metadata.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseMetadata", licenseMetadataValue)
    def clientToken: ZIO[Any, Nothing, primitives.ClientToken] = ZIO.succeed(clientTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest) extends CreateLicenseRequest.ReadOnly {
    override def licenseNameValue: String = impl.licenseName(): String
    override def productNameValue: String = impl.productName(): String
    override def productSKUValue: String = impl.productSKU(): String
    override def issuerValue: Issuer.ReadOnly = Issuer.wrap(impl.issuer())
    override def homeRegionValue: String = impl.homeRegion(): String
    override def validityValue: DatetimeRange.ReadOnly = DatetimeRange.wrap(impl.validity())
    override def entitlementsValue: List[Entitlement.ReadOnly] = impl.entitlements().asScala.map { item => 
      Entitlement.wrap(item)
    }.toList
    override def beneficiaryValue: String = impl.beneficiary(): String
    override def consumptionConfigurationValue: ConsumptionConfiguration.ReadOnly = ConsumptionConfiguration.wrap(impl.consumptionConfiguration())
    override def licenseMetadataValue: scala.Option[List[Metadata.ReadOnly]] = scala.Option(impl.licenseMetadata()).map(value => value.asScala.map { item => 
      Metadata.wrap(item)
    }.toList)
    override def clientTokenValue: primitives.ClientToken = impl.clientToken(): primitives.ClientToken
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest): ReadOnly = new Wrapper(impl)
}