package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ConsumedLicenseSummary(resourceType: scala.Option[ResourceType] = None, consumedLicenses: scala.Option[primitives.BoxLong] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary = {
    import ConsumedLicenseSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary.builder().optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(consumedLicenses.map(value => value: java.lang.Long))(_.consumedLicenses).build()
  }
  def asReadOnly: ConsumedLicenseSummary.ReadOnly = ConsumedLicenseSummary.wrap(buildAwsValue())
}
object ConsumedLicenseSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ConsumedLicenseSummary = ConsumedLicenseSummary(resourceTypeValue.map(value => value), consumedLicensesValue.map(value => value))
    def resourceTypeValue: scala.Option[ResourceType]
    def consumedLicensesValue: scala.Option[primitives.BoxLong]
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def consumedLicenses: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxLong] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("consumedLicenses", consumedLicensesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary) extends ConsumedLicenseSummary.ReadOnly {
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def consumedLicensesValue: scala.Option[primitives.BoxLong] = scala.Option(impl.consumedLicenses()).map(value => value: primitives.BoxLong)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary): ReadOnly = new Wrapper(impl)
}