package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait CheckoutType { def unwrap: software.amazon.awssdk.services.licensemanager.model.CheckoutType }
object CheckoutType {
  def wrap(value: software.amazon.awssdk.services.licensemanager.model.CheckoutType): CheckoutType = value match {
    case software.amazon.awssdk.services.licensemanager.model.CheckoutType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.CheckoutType.PROVISIONAL =>
      val r = PROVISIONAL
      r
    case software.amazon.awssdk.services.licensemanager.model.CheckoutType.PERPETUAL =>
      val r = PERPETUAL
      r
  }
  case object unknownToSdkVersion extends CheckoutType { override def unwrap: software.amazon.awssdk.services.licensemanager.model.CheckoutType = software.amazon.awssdk.services.licensemanager.model.CheckoutType.UNKNOWN_TO_SDK_VERSION }
  case object PROVISIONAL extends CheckoutType { override def unwrap: software.amazon.awssdk.services.licensemanager.model.CheckoutType = software.amazon.awssdk.services.licensemanager.model.CheckoutType.PROVISIONAL }
  case object PERPETUAL extends CheckoutType { override def unwrap: software.amazon.awssdk.services.licensemanager.model.CheckoutType = software.amazon.awssdk.services.licensemanager.model.CheckoutType.PERPETUAL }
}