package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CheckoutBorrowLicenseRequest(licenseArn: primitives.Arn, entitlements: Iterable[EntitlementData], digitalSignatureMethod: DigitalSignatureMethod, nodeId: scala.Option[String] = None, checkoutMetadata: scala.Option[Iterable[Metadata]] = None, clientToken: primitives.ClientToken) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest = {
    import CheckoutBorrowLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest.builder().licenseArn(licenseArn: java.lang.String).entitlements(entitlements.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).digitalSignatureMethod(digitalSignatureMethod.unwrap).optionallyWith(nodeId.map(value => value: java.lang.String))(_.nodeId).optionallyWith(checkoutMetadata.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.checkoutMetadata).clientToken(clientToken: java.lang.String).build()
  }
  def asReadOnly: CheckoutBorrowLicenseRequest.ReadOnly = CheckoutBorrowLicenseRequest.wrap(buildAwsValue())
}
object CheckoutBorrowLicenseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CheckoutBorrowLicenseRequest = CheckoutBorrowLicenseRequest(licenseArnValue, entitlementsValue.map { item => 
      item.editable
    }, digitalSignatureMethodValue, nodeIdValue.map(value => value), checkoutMetadataValue.map(value => value.map { item => 
      item.editable
    }), clientTokenValue)
    def licenseArnValue: primitives.Arn
    def entitlementsValue: List[EntitlementData.ReadOnly]
    def digitalSignatureMethodValue: DigitalSignatureMethod
    def nodeIdValue: scala.Option[String]
    def checkoutMetadataValue: scala.Option[List[Metadata.ReadOnly]]
    def clientTokenValue: primitives.ClientToken
    def licenseArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(licenseArnValue)
    def entitlements: ZIO[Any, Nothing, List[EntitlementData.ReadOnly]] = ZIO.succeed(entitlementsValue)
    def digitalSignatureMethod: ZIO[Any, Nothing, DigitalSignatureMethod] = ZIO.succeed(digitalSignatureMethodValue)
    def nodeId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nodeId", nodeIdValue)
    def checkoutMetadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Metadata.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("checkoutMetadata", checkoutMetadataValue)
    def clientToken: ZIO[Any, Nothing, primitives.ClientToken] = ZIO.succeed(clientTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest) extends CheckoutBorrowLicenseRequest.ReadOnly {
    override def licenseArnValue: primitives.Arn = impl.licenseArn(): primitives.Arn
    override def entitlementsValue: List[EntitlementData.ReadOnly] = impl.entitlements().asScala.map { item => 
      EntitlementData.wrap(item)
    }.toList
    override def digitalSignatureMethodValue: DigitalSignatureMethod = DigitalSignatureMethod.wrap(impl.digitalSignatureMethod())
    override def nodeIdValue: scala.Option[String] = scala.Option(impl.nodeId()).map(value => value: String)
    override def checkoutMetadataValue: scala.Option[List[Metadata.ReadOnly]] = scala.Option(impl.checkoutMetadata()).map(value => value.asScala.map { item => 
      Metadata.wrap(item)
    }.toList)
    override def clientTokenValue: primitives.ClientToken = impl.clientToken(): primitives.ClientToken
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest): ReadOnly = new Wrapper(impl)
}