package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CheckInLicenseRequest(licenseConsumptionToken: String, beneficiary: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest = {
    import CheckInLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest.builder().licenseConsumptionToken(licenseConsumptionToken: java.lang.String).optionallyWith(beneficiary.map(value => value: java.lang.String))(_.beneficiary).build()
  }
  def asReadOnly: CheckInLicenseRequest.ReadOnly = CheckInLicenseRequest.wrap(buildAwsValue())
}
object CheckInLicenseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CheckInLicenseRequest = CheckInLicenseRequest(licenseConsumptionTokenValue, beneficiaryValue.map(value => value))
    def licenseConsumptionTokenValue: String
    def beneficiaryValue: scala.Option[String]
    def licenseConsumptionToken: ZIO[Any, Nothing, String] = ZIO.succeed(licenseConsumptionTokenValue)
    def beneficiary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("beneficiary", beneficiaryValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest) extends CheckInLicenseRequest.ReadOnly {
    override def licenseConsumptionTokenValue: String = impl.licenseConsumptionToken(): String
    override def beneficiaryValue: scala.Option[String] = scala.Option(impl.beneficiary()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest): ReadOnly = new Wrapper(impl)
}