package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AutomatedDiscoveryInformation(lastRunTime: scala.Option[primitives.DateTime] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation = {
    import AutomatedDiscoveryInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation.builder().optionallyWith(lastRunTime.map(value => value: java.time.Instant))(_.lastRunTime).build()
  }
  def asReadOnly: AutomatedDiscoveryInformation.ReadOnly = AutomatedDiscoveryInformation.wrap(buildAwsValue())
}
object AutomatedDiscoveryInformation {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AutomatedDiscoveryInformation = AutomatedDiscoveryInformation(lastRunTimeValue.map(value => value))
    def lastRunTimeValue: scala.Option[primitives.DateTime]
    def lastRunTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastRunTime", lastRunTimeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation) extends AutomatedDiscoveryInformation.ReadOnly { override def lastRunTimeValue: scala.Option[primitives.DateTime] = scala.Option(impl.lastRunTime()).map(value => value: primitives.DateTime) }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation): ReadOnly = new Wrapper(impl)
}