package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AcceptGrantRequest(grantArn: primitives.Arn) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest = {
    import AcceptGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest.builder().grantArn(grantArn: java.lang.String).build()
  }
  def asReadOnly: AcceptGrantRequest.ReadOnly = AcceptGrantRequest.wrap(buildAwsValue())
}
object AcceptGrantRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AcceptGrantRequest = AcceptGrantRequest(grantArnValue)
    def grantArnValue: primitives.Arn
    def grantArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(grantArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest) extends AcceptGrantRequest.ReadOnly { override def grantArnValue: primitives.Arn = impl.grantArn(): primitives.Arn }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest): ReadOnly = new Wrapper(impl)
}