package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core.*
import io.github.vigoo.zioaws.core.aspects.*
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.licensemanager.{ LicenseManagerAsyncClient, LicenseManagerAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters.*
package object licensemanager {
  type LicenseManager = Has[LicenseManager.Service]
  object LicenseManager {
    trait Service extends AspectSupport[Service] {
      val api: LicenseManagerAsyncClient
      def checkoutLicense(request: model.CheckoutLicenseRequest): IO[AwsError, model.CheckoutLicenseResponse.ReadOnly]
      def listLicenseManagerReportGenerators(request: model.ListLicenseManagerReportGeneratorsRequest): ZStream[Any, AwsError, model.ReportGenerator.ReadOnly]
      def getServiceSettings(request: model.GetServiceSettingsRequest): IO[AwsError, model.GetServiceSettingsResponse.ReadOnly]
      def createToken(request: model.CreateTokenRequest): IO[AwsError, model.CreateTokenResponse.ReadOnly]
      def createLicense(request: model.CreateLicenseRequest): IO[AwsError, model.CreateLicenseResponse.ReadOnly]
      def deleteLicenseConfiguration(request: model.DeleteLicenseConfigurationRequest): IO[AwsError, model.DeleteLicenseConfigurationResponse.ReadOnly]
      def createGrant(request: model.CreateGrantRequest): IO[AwsError, model.CreateGrantResponse.ReadOnly]
      def checkoutBorrowLicense(request: model.CheckoutBorrowLicenseRequest): IO[AwsError, model.CheckoutBorrowLicenseResponse.ReadOnly]
      def createGrantVersion(request: model.CreateGrantVersionRequest): IO[AwsError, model.CreateGrantVersionResponse.ReadOnly]
      def getGrant(request: model.GetGrantRequest): IO[AwsError, model.GetGrantResponse.ReadOnly]
      def deleteToken(request: model.DeleteTokenRequest): IO[AwsError, model.DeleteTokenResponse.ReadOnly]
      def listResourceInventory(request: model.ListResourceInventoryRequest): ZStream[Any, AwsError, model.ResourceInventory.ReadOnly]
      def getAccessToken(request: model.GetAccessTokenRequest): IO[AwsError, model.GetAccessTokenResponse.ReadOnly]
      def listLicenses(request: model.ListLicensesRequest): ZStream[Any, AwsError, model.License.ReadOnly]
      def updateLicenseConfiguration(request: model.UpdateLicenseConfigurationRequest): IO[AwsError, model.UpdateLicenseConfigurationResponse.ReadOnly]
      def createLicenseVersion(request: model.CreateLicenseVersionRequest): IO[AwsError, model.CreateLicenseVersionResponse.ReadOnly]
      def createLicenseManagerReportGenerator(request: model.CreateLicenseManagerReportGeneratorRequest): IO[AwsError, model.CreateLicenseManagerReportGeneratorResponse.ReadOnly]
      def listLicenseSpecificationsForResource(request: model.ListLicenseSpecificationsForResourceRequest): ZStream[Any, AwsError, model.LicenseSpecification.ReadOnly]
      def deleteGrant(request: model.DeleteGrantRequest): IO[AwsError, model.DeleteGrantResponse.ReadOnly]
      def rejectGrant(request: model.RejectGrantRequest): IO[AwsError, model.RejectGrantResponse.ReadOnly]
      def checkInLicense(request: model.CheckInLicenseRequest): IO[AwsError, model.CheckInLicenseResponse.ReadOnly]
      def updateServiceSettings(request: model.UpdateServiceSettingsRequest): IO[AwsError, model.UpdateServiceSettingsResponse.ReadOnly]
      def getLicenseConfiguration(request: model.GetLicenseConfigurationRequest): IO[AwsError, model.GetLicenseConfigurationResponse.ReadOnly]
      def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly]
      def listAssociationsForLicenseConfiguration(request: model.ListAssociationsForLicenseConfigurationRequest): ZStream[Any, AwsError, model.LicenseConfigurationAssociation.ReadOnly]
      def deleteLicenseManagerReportGenerator(request: model.DeleteLicenseManagerReportGeneratorRequest): IO[AwsError, model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly]
      def acceptGrant(request: model.AcceptGrantRequest): IO[AwsError, model.AcceptGrantResponse.ReadOnly]
      def updateLicenseSpecificationsForResource(request: model.UpdateLicenseSpecificationsForResourceRequest): IO[AwsError, model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly]
      def updateLicenseManagerReportGenerator(request: model.UpdateLicenseManagerReportGeneratorRequest): IO[AwsError, model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly]
      def deleteLicense(request: model.DeleteLicenseRequest): IO[AwsError, model.DeleteLicenseResponse.ReadOnly]
      def extendLicenseConsumption(request: model.ExtendLicenseConsumptionRequest): IO[AwsError, model.ExtendLicenseConsumptionResponse.ReadOnly]
      def listLicenseConfigurations(request: model.ListLicenseConfigurationsRequest): ZStream[Any, AwsError, model.LicenseConfiguration.ReadOnly]
      def listTokens(request: model.ListTokensRequest): ZStream[Any, AwsError, model.TokenData.ReadOnly]
      def listDistributedGrants(request: model.ListDistributedGrantsRequest): ZStream[Any, AwsError, model.Grant.ReadOnly]
      def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly]
      def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly]
      def listLicenseVersions(request: model.ListLicenseVersionsRequest): ZStream[Any, AwsError, model.License.ReadOnly]
      def getLicenseUsage(request: model.GetLicenseUsageRequest): IO[AwsError, model.GetLicenseUsageResponse.ReadOnly]
      def getLicense(request: model.GetLicenseRequest): IO[AwsError, model.GetLicenseResponse.ReadOnly]
      def createLicenseConfiguration(request: model.CreateLicenseConfigurationRequest): IO[AwsError, model.CreateLicenseConfigurationResponse.ReadOnly]
      def listReceivedLicenses(request: model.ListReceivedLicensesRequest): ZStream[Any, AwsError, model.GrantedLicense.ReadOnly]
      def listReceivedGrants(request: model.ListReceivedGrantsRequest): ZStream[Any, AwsError, model.Grant.ReadOnly]
      def listUsageForLicenseConfiguration(request: model.ListUsageForLicenseConfigurationRequest): ZStream[Any, AwsError, model.LicenseConfigurationUsage.ReadOnly]
      def listFailuresForLicenseConfigurationOperations(request: model.ListFailuresForLicenseConfigurationOperationsRequest): ZStream[Any, AwsError, model.LicenseOperationFailure.ReadOnly]
      def getLicenseManagerReportGenerator(request: model.GetLicenseManagerReportGeneratorRequest): IO[AwsError, model.GetLicenseManagerReportGeneratorResponse.ReadOnly]
    }
    object LicenseManagerMock extends zio.test.mock.Mock[LicenseManager] {
      object CheckoutLicense extends Effect[model.CheckoutLicenseRequest, AwsError, model.CheckoutLicenseResponse.ReadOnly]
      object ListLicenseManagerReportGenerators extends Stream[model.ListLicenseManagerReportGeneratorsRequest, AwsError, model.ReportGenerator.ReadOnly]
      object GetServiceSettings extends Effect[model.GetServiceSettingsRequest, AwsError, model.GetServiceSettingsResponse.ReadOnly]
      object CreateToken extends Effect[model.CreateTokenRequest, AwsError, model.CreateTokenResponse.ReadOnly]
      object CreateLicense extends Effect[model.CreateLicenseRequest, AwsError, model.CreateLicenseResponse.ReadOnly]
      object DeleteLicenseConfiguration extends Effect[model.DeleteLicenseConfigurationRequest, AwsError, model.DeleteLicenseConfigurationResponse.ReadOnly]
      object CreateGrant extends Effect[model.CreateGrantRequest, AwsError, model.CreateGrantResponse.ReadOnly]
      object CheckoutBorrowLicense extends Effect[model.CheckoutBorrowLicenseRequest, AwsError, model.CheckoutBorrowLicenseResponse.ReadOnly]
      object CreateGrantVersion extends Effect[model.CreateGrantVersionRequest, AwsError, model.CreateGrantVersionResponse.ReadOnly]
      object GetGrant extends Effect[model.GetGrantRequest, AwsError, model.GetGrantResponse.ReadOnly]
      object DeleteToken extends Effect[model.DeleteTokenRequest, AwsError, model.DeleteTokenResponse.ReadOnly]
      object ListResourceInventory extends Stream[model.ListResourceInventoryRequest, AwsError, model.ResourceInventory.ReadOnly]
      object GetAccessToken extends Effect[model.GetAccessTokenRequest, AwsError, model.GetAccessTokenResponse.ReadOnly]
      object ListLicenses extends Stream[model.ListLicensesRequest, AwsError, model.License.ReadOnly]
      object UpdateLicenseConfiguration extends Effect[model.UpdateLicenseConfigurationRequest, AwsError, model.UpdateLicenseConfigurationResponse.ReadOnly]
      object CreateLicenseVersion extends Effect[model.CreateLicenseVersionRequest, AwsError, model.CreateLicenseVersionResponse.ReadOnly]
      object CreateLicenseManagerReportGenerator extends Effect[model.CreateLicenseManagerReportGeneratorRequest, AwsError, model.CreateLicenseManagerReportGeneratorResponse.ReadOnly]
      object ListLicenseSpecificationsForResource extends Stream[model.ListLicenseSpecificationsForResourceRequest, AwsError, model.LicenseSpecification.ReadOnly]
      object DeleteGrant extends Effect[model.DeleteGrantRequest, AwsError, model.DeleteGrantResponse.ReadOnly]
      object RejectGrant extends Effect[model.RejectGrantRequest, AwsError, model.RejectGrantResponse.ReadOnly]
      object CheckInLicense extends Effect[model.CheckInLicenseRequest, AwsError, model.CheckInLicenseResponse.ReadOnly]
      object UpdateServiceSettings extends Effect[model.UpdateServiceSettingsRequest, AwsError, model.UpdateServiceSettingsResponse.ReadOnly]
      object GetLicenseConfiguration extends Effect[model.GetLicenseConfigurationRequest, AwsError, model.GetLicenseConfigurationResponse.ReadOnly]
      object UntagResource extends Effect[model.UntagResourceRequest, AwsError, model.UntagResourceResponse.ReadOnly]
      object ListAssociationsForLicenseConfiguration extends Stream[model.ListAssociationsForLicenseConfigurationRequest, AwsError, model.LicenseConfigurationAssociation.ReadOnly]
      object DeleteLicenseManagerReportGenerator extends Effect[model.DeleteLicenseManagerReportGeneratorRequest, AwsError, model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly]
      object AcceptGrant extends Effect[model.AcceptGrantRequest, AwsError, model.AcceptGrantResponse.ReadOnly]
      object UpdateLicenseSpecificationsForResource extends Effect[model.UpdateLicenseSpecificationsForResourceRequest, AwsError, model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly]
      object UpdateLicenseManagerReportGenerator extends Effect[model.UpdateLicenseManagerReportGeneratorRequest, AwsError, model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly]
      object DeleteLicense extends Effect[model.DeleteLicenseRequest, AwsError, model.DeleteLicenseResponse.ReadOnly]
      object ExtendLicenseConsumption extends Effect[model.ExtendLicenseConsumptionRequest, AwsError, model.ExtendLicenseConsumptionResponse.ReadOnly]
      object ListLicenseConfigurations extends Stream[model.ListLicenseConfigurationsRequest, AwsError, model.LicenseConfiguration.ReadOnly]
      object ListTokens extends Stream[model.ListTokensRequest, AwsError, model.TokenData.ReadOnly]
      object ListDistributedGrants extends Stream[model.ListDistributedGrantsRequest, AwsError, model.Grant.ReadOnly]
      object ListTagsForResource extends Effect[model.ListTagsForResourceRequest, AwsError, model.ListTagsForResourceResponse.ReadOnly]
      object TagResource extends Effect[model.TagResourceRequest, AwsError, model.TagResourceResponse.ReadOnly]
      object ListLicenseVersions extends Stream[model.ListLicenseVersionsRequest, AwsError, model.License.ReadOnly]
      object GetLicenseUsage extends Effect[model.GetLicenseUsageRequest, AwsError, model.GetLicenseUsageResponse.ReadOnly]
      object GetLicense extends Effect[model.GetLicenseRequest, AwsError, model.GetLicenseResponse.ReadOnly]
      object CreateLicenseConfiguration extends Effect[model.CreateLicenseConfigurationRequest, AwsError, model.CreateLicenseConfigurationResponse.ReadOnly]
      object ListReceivedLicenses extends Stream[model.ListReceivedLicensesRequest, AwsError, model.GrantedLicense.ReadOnly]
      object ListReceivedGrants extends Stream[model.ListReceivedGrantsRequest, AwsError, model.Grant.ReadOnly]
      object ListUsageForLicenseConfiguration extends Stream[model.ListUsageForLicenseConfigurationRequest, AwsError, model.LicenseConfigurationUsage.ReadOnly]
      object ListFailuresForLicenseConfigurationOperations extends Stream[model.ListFailuresForLicenseConfigurationOperationsRequest, AwsError, model.LicenseOperationFailure.ReadOnly]
      object GetLicenseManagerReportGenerator extends Effect[model.GetLicenseManagerReportGeneratorRequest, AwsError, model.GetLicenseManagerReportGeneratorResponse.ReadOnly]
      val compose: URLayer[Has[zio.test.mock.Proxy], LicenseManager] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new LicenseManager.Service {
            val api: LicenseManagerAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): LicenseManager.Service = this
            def checkoutLicense(request: model.CheckoutLicenseRequest): IO[AwsError, model.CheckoutLicenseResponse.ReadOnly] = proxy(CheckoutLicense, request)
            def listLicenseManagerReportGenerators(request: model.ListLicenseManagerReportGeneratorsRequest): ZStream[Any, AwsError, model.ReportGenerator.ReadOnly] = rts.unsafeRun(proxy(ListLicenseManagerReportGenerators, request))
            def getServiceSettings(request: model.GetServiceSettingsRequest): IO[AwsError, model.GetServiceSettingsResponse.ReadOnly] = proxy(GetServiceSettings, request)
            def createToken(request: model.CreateTokenRequest): IO[AwsError, model.CreateTokenResponse.ReadOnly] = proxy(CreateToken, request)
            def createLicense(request: model.CreateLicenseRequest): IO[AwsError, model.CreateLicenseResponse.ReadOnly] = proxy(CreateLicense, request)
            def deleteLicenseConfiguration(request: model.DeleteLicenseConfigurationRequest): IO[AwsError, model.DeleteLicenseConfigurationResponse.ReadOnly] = proxy(DeleteLicenseConfiguration, request)
            def createGrant(request: model.CreateGrantRequest): IO[AwsError, model.CreateGrantResponse.ReadOnly] = proxy(CreateGrant, request)
            def checkoutBorrowLicense(request: model.CheckoutBorrowLicenseRequest): IO[AwsError, model.CheckoutBorrowLicenseResponse.ReadOnly] = proxy(CheckoutBorrowLicense, request)
            def createGrantVersion(request: model.CreateGrantVersionRequest): IO[AwsError, model.CreateGrantVersionResponse.ReadOnly] = proxy(CreateGrantVersion, request)
            def getGrant(request: model.GetGrantRequest): IO[AwsError, model.GetGrantResponse.ReadOnly] = proxy(GetGrant, request)
            def deleteToken(request: model.DeleteTokenRequest): IO[AwsError, model.DeleteTokenResponse.ReadOnly] = proxy(DeleteToken, request)
            def listResourceInventory(request: model.ListResourceInventoryRequest): ZStream[Any, AwsError, model.ResourceInventory.ReadOnly] = rts.unsafeRun(proxy(ListResourceInventory, request))
            def getAccessToken(request: model.GetAccessTokenRequest): IO[AwsError, model.GetAccessTokenResponse.ReadOnly] = proxy(GetAccessToken, request)
            def listLicenses(request: model.ListLicensesRequest): ZStream[Any, AwsError, model.License.ReadOnly] = rts.unsafeRun(proxy(ListLicenses, request))
            def updateLicenseConfiguration(request: model.UpdateLicenseConfigurationRequest): IO[AwsError, model.UpdateLicenseConfigurationResponse.ReadOnly] = proxy(UpdateLicenseConfiguration, request)
            def createLicenseVersion(request: model.CreateLicenseVersionRequest): IO[AwsError, model.CreateLicenseVersionResponse.ReadOnly] = proxy(CreateLicenseVersion, request)
            def createLicenseManagerReportGenerator(request: model.CreateLicenseManagerReportGeneratorRequest): IO[AwsError, model.CreateLicenseManagerReportGeneratorResponse.ReadOnly] = proxy(CreateLicenseManagerReportGenerator, request)
            def listLicenseSpecificationsForResource(request: model.ListLicenseSpecificationsForResourceRequest): ZStream[Any, AwsError, model.LicenseSpecification.ReadOnly] = rts.unsafeRun(proxy(ListLicenseSpecificationsForResource, request))
            def deleteGrant(request: model.DeleteGrantRequest): IO[AwsError, model.DeleteGrantResponse.ReadOnly] = proxy(DeleteGrant, request)
            def rejectGrant(request: model.RejectGrantRequest): IO[AwsError, model.RejectGrantResponse.ReadOnly] = proxy(RejectGrant, request)
            def checkInLicense(request: model.CheckInLicenseRequest): IO[AwsError, model.CheckInLicenseResponse.ReadOnly] = proxy(CheckInLicense, request)
            def updateServiceSettings(request: model.UpdateServiceSettingsRequest): IO[AwsError, model.UpdateServiceSettingsResponse.ReadOnly] = proxy(UpdateServiceSettings, request)
            def getLicenseConfiguration(request: model.GetLicenseConfigurationRequest): IO[AwsError, model.GetLicenseConfigurationResponse.ReadOnly] = proxy(GetLicenseConfiguration, request)
            def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly] = proxy(UntagResource, request)
            def listAssociationsForLicenseConfiguration(request: model.ListAssociationsForLicenseConfigurationRequest): ZStream[Any, AwsError, model.LicenseConfigurationAssociation.ReadOnly] = rts.unsafeRun(proxy(ListAssociationsForLicenseConfiguration, request))
            def deleteLicenseManagerReportGenerator(request: model.DeleteLicenseManagerReportGeneratorRequest): IO[AwsError, model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly] = proxy(DeleteLicenseManagerReportGenerator, request)
            def acceptGrant(request: model.AcceptGrantRequest): IO[AwsError, model.AcceptGrantResponse.ReadOnly] = proxy(AcceptGrant, request)
            def updateLicenseSpecificationsForResource(request: model.UpdateLicenseSpecificationsForResourceRequest): IO[AwsError, model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly] = proxy(UpdateLicenseSpecificationsForResource, request)
            def updateLicenseManagerReportGenerator(request: model.UpdateLicenseManagerReportGeneratorRequest): IO[AwsError, model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly] = proxy(UpdateLicenseManagerReportGenerator, request)
            def deleteLicense(request: model.DeleteLicenseRequest): IO[AwsError, model.DeleteLicenseResponse.ReadOnly] = proxy(DeleteLicense, request)
            def extendLicenseConsumption(request: model.ExtendLicenseConsumptionRequest): IO[AwsError, model.ExtendLicenseConsumptionResponse.ReadOnly] = proxy(ExtendLicenseConsumption, request)
            def listLicenseConfigurations(request: model.ListLicenseConfigurationsRequest): ZStream[Any, AwsError, model.LicenseConfiguration.ReadOnly] = rts.unsafeRun(proxy(ListLicenseConfigurations, request))
            def listTokens(request: model.ListTokensRequest): ZStream[Any, AwsError, model.TokenData.ReadOnly] = rts.unsafeRun(proxy(ListTokens, request))
            def listDistributedGrants(request: model.ListDistributedGrantsRequest): ZStream[Any, AwsError, model.Grant.ReadOnly] = rts.unsafeRun(proxy(ListDistributedGrants, request))
            def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly] = proxy(ListTagsForResource, request)
            def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly] = proxy(TagResource, request)
            def listLicenseVersions(request: model.ListLicenseVersionsRequest): ZStream[Any, AwsError, model.License.ReadOnly] = rts.unsafeRun(proxy(ListLicenseVersions, request))
            def getLicenseUsage(request: model.GetLicenseUsageRequest): IO[AwsError, model.GetLicenseUsageResponse.ReadOnly] = proxy(GetLicenseUsage, request)
            def getLicense(request: model.GetLicenseRequest): IO[AwsError, model.GetLicenseResponse.ReadOnly] = proxy(GetLicense, request)
            def createLicenseConfiguration(request: model.CreateLicenseConfigurationRequest): IO[AwsError, model.CreateLicenseConfigurationResponse.ReadOnly] = proxy(CreateLicenseConfiguration, request)
            def listReceivedLicenses(request: model.ListReceivedLicensesRequest): ZStream[Any, AwsError, model.GrantedLicense.ReadOnly] = rts.unsafeRun(proxy(ListReceivedLicenses, request))
            def listReceivedGrants(request: model.ListReceivedGrantsRequest): ZStream[Any, AwsError, model.Grant.ReadOnly] = rts.unsafeRun(proxy(ListReceivedGrants, request))
            def listUsageForLicenseConfiguration(request: model.ListUsageForLicenseConfigurationRequest): ZStream[Any, AwsError, model.LicenseConfigurationUsage.ReadOnly] = rts.unsafeRun(proxy(ListUsageForLicenseConfiguration, request))
            def listFailuresForLicenseConfigurationOperations(request: model.ListFailuresForLicenseConfigurationOperationsRequest): ZStream[Any, AwsError, model.LicenseOperationFailure.ReadOnly] = rts.unsafeRun(proxy(ListFailuresForLicenseConfigurationOperations, request))
            def getLicenseManagerReportGenerator(request: model.GetLicenseManagerReportGeneratorRequest): IO[AwsError, model.GetLicenseManagerReportGeneratorResponse.ReadOnly] = proxy(GetLicenseManagerReportGenerator, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, LicenseManager] = customized(identity)
  def customized(customization: LicenseManagerAsyncClientBuilder => LicenseManagerAsyncClientBuilder): ZLayer[AwsConfig, Throwable, LicenseManager] = managed(customization).toLayer
  def managed(customization: LicenseManagerAsyncClientBuilder => LicenseManagerAsyncClientBuilder): ZManaged[AwsConfig, Throwable, LicenseManager.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = LicenseManagerAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[LicenseManagerAsyncClient, LicenseManagerAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[LicenseManagerAsyncClient, LicenseManagerAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new LicenseManagerImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class LicenseManagerImpl[R](override val api: LicenseManagerAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends LicenseManager.Service with AwsServiceBase[R, LicenseManagerImpl] {
    override val serviceName: String = "LicenseManager"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): LicenseManagerImpl[R1] = new LicenseManagerImpl(api, newAspect, r)
    def checkoutLicense(request: model.CheckoutLicenseRequest): IO[AwsError, model.CheckoutLicenseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest, software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse]("checkoutLicense", api.checkoutLicense)(request.buildAwsValue()).map(model.CheckoutLicenseResponse.wrap).provide(r)
    def listLicenseManagerReportGenerators(request: model.ListLicenseManagerReportGeneratorsRequest): ZStream[Any, AwsError, model.ReportGenerator.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest, software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse, software.amazon.awssdk.services.licensemanager.model.ReportGenerator]("listLicenseManagerReportGenerators", api.listLicenseManagerReportGenerators, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.reportGenerators().asScala))(request.buildAwsValue()).map(item => model.ReportGenerator.wrap(item)).provide(r)
    def getServiceSettings(request: model.GetServiceSettingsRequest): IO[AwsError, model.GetServiceSettingsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsRequest, software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse]("getServiceSettings", api.getServiceSettings)(request.buildAwsValue()).map(model.GetServiceSettingsResponse.wrap).provide(r)
    def createToken(request: model.CreateTokenRequest): IO[AwsError, model.CreateTokenResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest, software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse]("createToken", api.createToken)(request.buildAwsValue()).map(model.CreateTokenResponse.wrap).provide(r)
    def createLicense(request: model.CreateLicenseRequest): IO[AwsError, model.CreateLicenseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest, software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse]("createLicense", api.createLicense)(request.buildAwsValue()).map(model.CreateLicenseResponse.wrap).provide(r)
    def deleteLicenseConfiguration(request: model.DeleteLicenseConfigurationRequest): IO[AwsError, model.DeleteLicenseConfigurationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest, software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationResponse]("deleteLicenseConfiguration", api.deleteLicenseConfiguration)(request.buildAwsValue()).map(model.DeleteLicenseConfigurationResponse.wrap).provide(r)
    def createGrant(request: model.CreateGrantRequest): IO[AwsError, model.CreateGrantResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest, software.amazon.awssdk.services.licensemanager.model.CreateGrantResponse]("createGrant", api.createGrant)(request.buildAwsValue()).map(model.CreateGrantResponse.wrap).provide(r)
    def checkoutBorrowLicense(request: model.CheckoutBorrowLicenseRequest): IO[AwsError, model.CheckoutBorrowLicenseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest, software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse]("checkoutBorrowLicense", api.checkoutBorrowLicense)(request.buildAwsValue()).map(model.CheckoutBorrowLicenseResponse.wrap).provide(r)
    def createGrantVersion(request: model.CreateGrantVersionRequest): IO[AwsError, model.CreateGrantVersionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest, software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse]("createGrantVersion", api.createGrantVersion)(request.buildAwsValue()).map(model.CreateGrantVersionResponse.wrap).provide(r)
    def getGrant(request: model.GetGrantRequest): IO[AwsError, model.GetGrantResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.GetGrantRequest, software.amazon.awssdk.services.licensemanager.model.GetGrantResponse]("getGrant", api.getGrant)(request.buildAwsValue()).map(model.GetGrantResponse.wrap).provide(r)
    def deleteToken(request: model.DeleteTokenRequest): IO[AwsError, model.DeleteTokenResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest, software.amazon.awssdk.services.licensemanager.model.DeleteTokenResponse]("deleteToken", api.deleteToken)(request.buildAwsValue()).map(model.DeleteTokenResponse.wrap).provide(r)
    def listResourceInventory(request: model.ListResourceInventoryRequest): ZStream[Any, AwsError, model.ResourceInventory.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest, software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse, software.amazon.awssdk.services.licensemanager.model.ResourceInventory]("listResourceInventory", api.listResourceInventory, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.resourceInventoryList().asScala))(request.buildAwsValue()).map(item => model.ResourceInventory.wrap(item)).provide(r)
    def getAccessToken(request: model.GetAccessTokenRequest): IO[AwsError, model.GetAccessTokenResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest, software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse]("getAccessToken", api.getAccessToken)(request.buildAwsValue()).map(model.GetAccessTokenResponse.wrap).provide(r)
    def listLicenses(request: model.ListLicensesRequest): ZStream[Any, AwsError, model.License.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListLicensesRequest, software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse, software.amazon.awssdk.services.licensemanager.model.License]("listLicenses", api.listLicenses, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.licenses().asScala))(request.buildAwsValue()).map(item => model.License.wrap(item)).provide(r)
    def updateLicenseConfiguration(request: model.UpdateLicenseConfigurationRequest): IO[AwsError, model.UpdateLicenseConfigurationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest, software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationResponse]("updateLicenseConfiguration", api.updateLicenseConfiguration)(request.buildAwsValue()).map(model.UpdateLicenseConfigurationResponse.wrap).provide(r)
    def createLicenseVersion(request: model.CreateLicenseVersionRequest): IO[AwsError, model.CreateLicenseVersionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest, software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse]("createLicenseVersion", api.createLicenseVersion)(request.buildAwsValue()).map(model.CreateLicenseVersionResponse.wrap).provide(r)
    def createLicenseManagerReportGenerator(request: model.CreateLicenseManagerReportGeneratorRequest): IO[AwsError, model.CreateLicenseManagerReportGeneratorResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest, software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse]("createLicenseManagerReportGenerator", api.createLicenseManagerReportGenerator)(request.buildAwsValue()).map(model.CreateLicenseManagerReportGeneratorResponse.wrap).provide(r)
    def listLicenseSpecificationsForResource(request: model.ListLicenseSpecificationsForResourceRequest): ZStream[Any, AwsError, model.LicenseSpecification.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest, software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse, software.amazon.awssdk.services.licensemanager.model.LicenseSpecification]("listLicenseSpecificationsForResource", api.listLicenseSpecificationsForResource, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.licenseSpecifications().asScala))(request.buildAwsValue()).map(item => model.LicenseSpecification.wrap(item)).provide(r)
    def deleteGrant(request: model.DeleteGrantRequest): IO[AwsError, model.DeleteGrantResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest, software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse]("deleteGrant", api.deleteGrant)(request.buildAwsValue()).map(model.DeleteGrantResponse.wrap).provide(r)
    def rejectGrant(request: model.RejectGrantRequest): IO[AwsError, model.RejectGrantResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest, software.amazon.awssdk.services.licensemanager.model.RejectGrantResponse]("rejectGrant", api.rejectGrant)(request.buildAwsValue()).map(model.RejectGrantResponse.wrap).provide(r)
    def checkInLicense(request: model.CheckInLicenseRequest): IO[AwsError, model.CheckInLicenseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest, software.amazon.awssdk.services.licensemanager.model.CheckInLicenseResponse]("checkInLicense", api.checkInLicense)(request.buildAwsValue()).map(model.CheckInLicenseResponse.wrap).provide(r)
    def updateServiceSettings(request: model.UpdateServiceSettingsRequest): IO[AwsError, model.UpdateServiceSettingsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest, software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsResponse]("updateServiceSettings", api.updateServiceSettings)(request.buildAwsValue()).map(model.UpdateServiceSettingsResponse.wrap).provide(r)
    def getLicenseConfiguration(request: model.GetLicenseConfigurationRequest): IO[AwsError, model.GetLicenseConfigurationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest, software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse]("getLicenseConfiguration", api.getLicenseConfiguration)(request.buildAwsValue()).map(model.GetLicenseConfigurationResponse.wrap).provide(r)
    def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest, software.amazon.awssdk.services.licensemanager.model.UntagResourceResponse]("untagResource", api.untagResource)(request.buildAwsValue()).map(model.UntagResourceResponse.wrap).provide(r)
    def listAssociationsForLicenseConfiguration(request: model.ListAssociationsForLicenseConfigurationRequest): ZStream[Any, AwsError, model.LicenseConfigurationAssociation.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest, software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse, software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation]("listAssociationsForLicenseConfiguration", api.listAssociationsForLicenseConfiguration, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.licenseConfigurationAssociations().asScala))(request.buildAwsValue()).map(item => model.LicenseConfigurationAssociation.wrap(item)).provide(r)
    def deleteLicenseManagerReportGenerator(request: model.DeleteLicenseManagerReportGeneratorRequest): IO[AwsError, model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest, software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse]("deleteLicenseManagerReportGenerator", api.deleteLicenseManagerReportGenerator)(request.buildAwsValue()).map(model.DeleteLicenseManagerReportGeneratorResponse.wrap).provide(r)
    def acceptGrant(request: model.AcceptGrantRequest): IO[AwsError, model.AcceptGrantResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest, software.amazon.awssdk.services.licensemanager.model.AcceptGrantResponse]("acceptGrant", api.acceptGrant)(request.buildAwsValue()).map(model.AcceptGrantResponse.wrap).provide(r)
    def updateLicenseSpecificationsForResource(request: model.UpdateLicenseSpecificationsForResourceRequest): IO[AwsError, model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest, software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse]("updateLicenseSpecificationsForResource", api.updateLicenseSpecificationsForResource)(request.buildAwsValue()).map(model.UpdateLicenseSpecificationsForResourceResponse.wrap).provide(r)
    def updateLicenseManagerReportGenerator(request: model.UpdateLicenseManagerReportGeneratorRequest): IO[AwsError, model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest, software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse]("updateLicenseManagerReportGenerator", api.updateLicenseManagerReportGenerator)(request.buildAwsValue()).map(model.UpdateLicenseManagerReportGeneratorResponse.wrap).provide(r)
    def deleteLicense(request: model.DeleteLicenseRequest): IO[AwsError, model.DeleteLicenseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest, software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse]("deleteLicense", api.deleteLicense)(request.buildAwsValue()).map(model.DeleteLicenseResponse.wrap).provide(r)
    def extendLicenseConsumption(request: model.ExtendLicenseConsumptionRequest): IO[AwsError, model.ExtendLicenseConsumptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest, software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse]("extendLicenseConsumption", api.extendLicenseConsumption)(request.buildAwsValue()).map(model.ExtendLicenseConsumptionResponse.wrap).provide(r)
    def listLicenseConfigurations(request: model.ListLicenseConfigurationsRequest): ZStream[Any, AwsError, model.LicenseConfiguration.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsRequest, software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse, software.amazon.awssdk.services.licensemanager.model.LicenseConfiguration]("listLicenseConfigurations", api.listLicenseConfigurations, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.licenseConfigurations().asScala))(request.buildAwsValue()).map(item => model.LicenseConfiguration.wrap(item)).provide(r)
    def listTokens(request: model.ListTokensRequest): ZStream[Any, AwsError, model.TokenData.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListTokensRequest, software.amazon.awssdk.services.licensemanager.model.ListTokensResponse, software.amazon.awssdk.services.licensemanager.model.TokenData]("listTokens", api.listTokens, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.tokens().asScala))(request.buildAwsValue()).map(item => model.TokenData.wrap(item)).provide(r)
    def listDistributedGrants(request: model.ListDistributedGrantsRequest): ZStream[Any, AwsError, model.Grant.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest, software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse, software.amazon.awssdk.services.licensemanager.model.Grant]("listDistributedGrants", api.listDistributedGrants, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.grants().asScala))(request.buildAwsValue()).map(item => model.Grant.wrap(item)).provide(r)
    def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest, software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue()).map(model.ListTagsForResourceResponse.wrap).provide(r)
    def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.TagResourceRequest, software.amazon.awssdk.services.licensemanager.model.TagResourceResponse]("tagResource", api.tagResource)(request.buildAwsValue()).map(model.TagResourceResponse.wrap).provide(r)
    def listLicenseVersions(request: model.ListLicenseVersionsRequest): ZStream[Any, AwsError, model.License.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest, software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse, software.amazon.awssdk.services.licensemanager.model.License]("listLicenseVersions", api.listLicenseVersions, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.licenses().asScala))(request.buildAwsValue()).map(item => model.License.wrap(item)).provide(r)
    def getLicenseUsage(request: model.GetLicenseUsageRequest): IO[AwsError, model.GetLicenseUsageResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest, software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse]("getLicenseUsage", api.getLicenseUsage)(request.buildAwsValue()).map(model.GetLicenseUsageResponse.wrap).provide(r)
    def getLicense(request: model.GetLicenseRequest): IO[AwsError, model.GetLicenseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest, software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse]("getLicense", api.getLicense)(request.buildAwsValue()).map(model.GetLicenseResponse.wrap).provide(r)
    def createLicenseConfiguration(request: model.CreateLicenseConfigurationRequest): IO[AwsError, model.CreateLicenseConfigurationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest, software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse]("createLicenseConfiguration", api.createLicenseConfiguration)(request.buildAwsValue()).map(model.CreateLicenseConfigurationResponse.wrap).provide(r)
    def listReceivedLicenses(request: model.ListReceivedLicensesRequest): ZStream[Any, AwsError, model.GrantedLicense.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesRequest, software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse, software.amazon.awssdk.services.licensemanager.model.GrantedLicense]("listReceivedLicenses", api.listReceivedLicenses, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.licenses().asScala))(request.buildAwsValue()).map(item => model.GrantedLicense.wrap(item)).provide(r)
    def listReceivedGrants(request: model.ListReceivedGrantsRequest): ZStream[Any, AwsError, model.Grant.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest, software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse, software.amazon.awssdk.services.licensemanager.model.Grant]("listReceivedGrants", api.listReceivedGrants, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.grants().asScala))(request.buildAwsValue()).map(item => model.Grant.wrap(item)).provide(r)
    def listUsageForLicenseConfiguration(request: model.ListUsageForLicenseConfigurationRequest): ZStream[Any, AwsError, model.LicenseConfigurationUsage.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest, software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse, software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage]("listUsageForLicenseConfiguration", api.listUsageForLicenseConfiguration, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.licenseConfigurationUsageList().asScala))(request.buildAwsValue()).map(item => model.LicenseConfigurationUsage.wrap(item)).provide(r)
    def listFailuresForLicenseConfigurationOperations(request: model.ListFailuresForLicenseConfigurationOperationsRequest): ZStream[Any, AwsError, model.LicenseOperationFailure.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest, software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse, software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure]("listFailuresForLicenseConfigurationOperations", api.listFailuresForLicenseConfigurationOperations, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.licenseOperationFailureList().asScala))(request.buildAwsValue()).map(item => model.LicenseOperationFailure.wrap(item)).provide(r)
    def getLicenseManagerReportGenerator(request: model.GetLicenseManagerReportGeneratorRequest): IO[AwsError, model.GetLicenseManagerReportGeneratorResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest, software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse]("getLicenseManagerReportGenerator", api.getLicenseManagerReportGenerator)(request.buildAwsValue()).map(model.GetLicenseManagerReportGeneratorResponse.wrap).provide(r)
  }
  def checkoutLicense(request: model.CheckoutLicenseRequest): ZIO[LicenseManager, AwsError, model.CheckoutLicenseResponse.ReadOnly] = ZIO.accessM(_.get.checkoutLicense(request))
  def listLicenseManagerReportGenerators(request: model.ListLicenseManagerReportGeneratorsRequest): ZStream[LicenseManager, AwsError, model.ReportGenerator.ReadOnly] = ZStream.accessStream(_.get.listLicenseManagerReportGenerators(request))
  def getServiceSettings(request: model.GetServiceSettingsRequest): ZIO[LicenseManager, AwsError, model.GetServiceSettingsResponse.ReadOnly] = ZIO.accessM(_.get.getServiceSettings(request))
  def createToken(request: model.CreateTokenRequest): ZIO[LicenseManager, AwsError, model.CreateTokenResponse.ReadOnly] = ZIO.accessM(_.get.createToken(request))
  def createLicense(request: model.CreateLicenseRequest): ZIO[LicenseManager, AwsError, model.CreateLicenseResponse.ReadOnly] = ZIO.accessM(_.get.createLicense(request))
  def deleteLicenseConfiguration(request: model.DeleteLicenseConfigurationRequest): ZIO[LicenseManager, AwsError, model.DeleteLicenseConfigurationResponse.ReadOnly] = ZIO.accessM(_.get.deleteLicenseConfiguration(request))
  def createGrant(request: model.CreateGrantRequest): ZIO[LicenseManager, AwsError, model.CreateGrantResponse.ReadOnly] = ZIO.accessM(_.get.createGrant(request))
  def checkoutBorrowLicense(request: model.CheckoutBorrowLicenseRequest): ZIO[LicenseManager, AwsError, model.CheckoutBorrowLicenseResponse.ReadOnly] = ZIO.accessM(_.get.checkoutBorrowLicense(request))
  def createGrantVersion(request: model.CreateGrantVersionRequest): ZIO[LicenseManager, AwsError, model.CreateGrantVersionResponse.ReadOnly] = ZIO.accessM(_.get.createGrantVersion(request))
  def getGrant(request: model.GetGrantRequest): ZIO[LicenseManager, AwsError, model.GetGrantResponse.ReadOnly] = ZIO.accessM(_.get.getGrant(request))
  def deleteToken(request: model.DeleteTokenRequest): ZIO[LicenseManager, AwsError, model.DeleteTokenResponse.ReadOnly] = ZIO.accessM(_.get.deleteToken(request))
  def listResourceInventory(request: model.ListResourceInventoryRequest): ZStream[LicenseManager, AwsError, model.ResourceInventory.ReadOnly] = ZStream.accessStream(_.get.listResourceInventory(request))
  def getAccessToken(request: model.GetAccessTokenRequest): ZIO[LicenseManager, AwsError, model.GetAccessTokenResponse.ReadOnly] = ZIO.accessM(_.get.getAccessToken(request))
  def listLicenses(request: model.ListLicensesRequest): ZStream[LicenseManager, AwsError, model.License.ReadOnly] = ZStream.accessStream(_.get.listLicenses(request))
  def updateLicenseConfiguration(request: model.UpdateLicenseConfigurationRequest): ZIO[LicenseManager, AwsError, model.UpdateLicenseConfigurationResponse.ReadOnly] = ZIO.accessM(_.get.updateLicenseConfiguration(request))
  def createLicenseVersion(request: model.CreateLicenseVersionRequest): ZIO[LicenseManager, AwsError, model.CreateLicenseVersionResponse.ReadOnly] = ZIO.accessM(_.get.createLicenseVersion(request))
  def createLicenseManagerReportGenerator(request: model.CreateLicenseManagerReportGeneratorRequest): ZIO[LicenseManager, AwsError, model.CreateLicenseManagerReportGeneratorResponse.ReadOnly] = ZIO.accessM(_.get.createLicenseManagerReportGenerator(request))
  def listLicenseSpecificationsForResource(request: model.ListLicenseSpecificationsForResourceRequest): ZStream[LicenseManager, AwsError, model.LicenseSpecification.ReadOnly] = ZStream.accessStream(_.get.listLicenseSpecificationsForResource(request))
  def deleteGrant(request: model.DeleteGrantRequest): ZIO[LicenseManager, AwsError, model.DeleteGrantResponse.ReadOnly] = ZIO.accessM(_.get.deleteGrant(request))
  def rejectGrant(request: model.RejectGrantRequest): ZIO[LicenseManager, AwsError, model.RejectGrantResponse.ReadOnly] = ZIO.accessM(_.get.rejectGrant(request))
  def checkInLicense(request: model.CheckInLicenseRequest): ZIO[LicenseManager, AwsError, model.CheckInLicenseResponse.ReadOnly] = ZIO.accessM(_.get.checkInLicense(request))
  def updateServiceSettings(request: model.UpdateServiceSettingsRequest): ZIO[LicenseManager, AwsError, model.UpdateServiceSettingsResponse.ReadOnly] = ZIO.accessM(_.get.updateServiceSettings(request))
  def getLicenseConfiguration(request: model.GetLicenseConfigurationRequest): ZIO[LicenseManager, AwsError, model.GetLicenseConfigurationResponse.ReadOnly] = ZIO.accessM(_.get.getLicenseConfiguration(request))
  def untagResource(request: model.UntagResourceRequest): ZIO[LicenseManager, AwsError, model.UntagResourceResponse.ReadOnly] = ZIO.accessM(_.get.untagResource(request))
  def listAssociationsForLicenseConfiguration(request: model.ListAssociationsForLicenseConfigurationRequest): ZStream[LicenseManager, AwsError, model.LicenseConfigurationAssociation.ReadOnly] = ZStream.accessStream(_.get.listAssociationsForLicenseConfiguration(request))
  def deleteLicenseManagerReportGenerator(request: model.DeleteLicenseManagerReportGeneratorRequest): ZIO[LicenseManager, AwsError, model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly] = ZIO.accessM(_.get.deleteLicenseManagerReportGenerator(request))
  def acceptGrant(request: model.AcceptGrantRequest): ZIO[LicenseManager, AwsError, model.AcceptGrantResponse.ReadOnly] = ZIO.accessM(_.get.acceptGrant(request))
  def updateLicenseSpecificationsForResource(request: model.UpdateLicenseSpecificationsForResourceRequest): ZIO[LicenseManager, AwsError, model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly] = ZIO.accessM(_.get.updateLicenseSpecificationsForResource(request))
  def updateLicenseManagerReportGenerator(request: model.UpdateLicenseManagerReportGeneratorRequest): ZIO[LicenseManager, AwsError, model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly] = ZIO.accessM(_.get.updateLicenseManagerReportGenerator(request))
  def deleteLicense(request: model.DeleteLicenseRequest): ZIO[LicenseManager, AwsError, model.DeleteLicenseResponse.ReadOnly] = ZIO.accessM(_.get.deleteLicense(request))
  def extendLicenseConsumption(request: model.ExtendLicenseConsumptionRequest): ZIO[LicenseManager, AwsError, model.ExtendLicenseConsumptionResponse.ReadOnly] = ZIO.accessM(_.get.extendLicenseConsumption(request))
  def listLicenseConfigurations(request: model.ListLicenseConfigurationsRequest): ZStream[LicenseManager, AwsError, model.LicenseConfiguration.ReadOnly] = ZStream.accessStream(_.get.listLicenseConfigurations(request))
  def listTokens(request: model.ListTokensRequest): ZStream[LicenseManager, AwsError, model.TokenData.ReadOnly] = ZStream.accessStream(_.get.listTokens(request))
  def listDistributedGrants(request: model.ListDistributedGrantsRequest): ZStream[LicenseManager, AwsError, model.Grant.ReadOnly] = ZStream.accessStream(_.get.listDistributedGrants(request))
  def listTagsForResource(request: model.ListTagsForResourceRequest): ZIO[LicenseManager, AwsError, model.ListTagsForResourceResponse.ReadOnly] = ZIO.accessM(_.get.listTagsForResource(request))
  def tagResource(request: model.TagResourceRequest): ZIO[LicenseManager, AwsError, model.TagResourceResponse.ReadOnly] = ZIO.accessM(_.get.tagResource(request))
  def listLicenseVersions(request: model.ListLicenseVersionsRequest): ZStream[LicenseManager, AwsError, model.License.ReadOnly] = ZStream.accessStream(_.get.listLicenseVersions(request))
  def getLicenseUsage(request: model.GetLicenseUsageRequest): ZIO[LicenseManager, AwsError, model.GetLicenseUsageResponse.ReadOnly] = ZIO.accessM(_.get.getLicenseUsage(request))
  def getLicense(request: model.GetLicenseRequest): ZIO[LicenseManager, AwsError, model.GetLicenseResponse.ReadOnly] = ZIO.accessM(_.get.getLicense(request))
  def createLicenseConfiguration(request: model.CreateLicenseConfigurationRequest): ZIO[LicenseManager, AwsError, model.CreateLicenseConfigurationResponse.ReadOnly] = ZIO.accessM(_.get.createLicenseConfiguration(request))
  def listReceivedLicenses(request: model.ListReceivedLicensesRequest): ZStream[LicenseManager, AwsError, model.GrantedLicense.ReadOnly] = ZStream.accessStream(_.get.listReceivedLicenses(request))
  def listReceivedGrants(request: model.ListReceivedGrantsRequest): ZStream[LicenseManager, AwsError, model.Grant.ReadOnly] = ZStream.accessStream(_.get.listReceivedGrants(request))
  def listUsageForLicenseConfiguration(request: model.ListUsageForLicenseConfigurationRequest): ZStream[LicenseManager, AwsError, model.LicenseConfigurationUsage.ReadOnly] = ZStream.accessStream(_.get.listUsageForLicenseConfiguration(request))
  def listFailuresForLicenseConfigurationOperations(request: model.ListFailuresForLicenseConfigurationOperationsRequest): ZStream[LicenseManager, AwsError, model.LicenseOperationFailure.ReadOnly] = ZStream.accessStream(_.get.listFailuresForLicenseConfigurationOperations(request))
  def getLicenseManagerReportGenerator(request: model.GetLicenseManagerReportGeneratorRequest): ZIO[LicenseManager, AwsError, model.GetLicenseManagerReportGeneratorResponse.ReadOnly] = ZIO.accessM(_.get.getLicenseManagerReportGenerator(request))
}