package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateLicenseManagerReportGeneratorRequest(licenseManagerReportGeneratorArn: String, reportGeneratorName: primitives.ReportGeneratorName, `type`: Iterable[ReportType], reportContext: ReportContext, reportFrequency: ReportFrequency, clientToken: primitives.ClientRequestToken, description: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest = {
    import UpdateLicenseManagerReportGeneratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest.builder().licenseManagerReportGeneratorArn(licenseManagerReportGeneratorArn: java.lang.String).reportGeneratorName(reportGeneratorName: java.lang.String).typeWithStrings(`type`.map { item => 
      item.unwrap.toString
    }.asJavaCollection).reportContext(reportContext.buildAwsValue()).reportFrequency(reportFrequency.buildAwsValue()).clientToken(clientToken: java.lang.String).optionallyWith(description.map(value => value: java.lang.String))(_.description).build()
  }
  def asReadOnly: UpdateLicenseManagerReportGeneratorRequest.ReadOnly = UpdateLicenseManagerReportGeneratorRequest.wrap(buildAwsValue())
}
object UpdateLicenseManagerReportGeneratorRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateLicenseManagerReportGeneratorRequest = UpdateLicenseManagerReportGeneratorRequest(licenseManagerReportGeneratorArnValue, reportGeneratorNameValue, typeValue, reportContextValue.editable, reportFrequencyValue.editable, clientTokenValue, descriptionValue.map(value => value))
    def licenseManagerReportGeneratorArnValue: String
    def reportGeneratorNameValue: primitives.ReportGeneratorName
    def typeValue: List[ReportType]
    def reportContextValue: ReportContext.ReadOnly
    def reportFrequencyValue: ReportFrequency.ReadOnly
    def clientTokenValue: primitives.ClientRequestToken
    def descriptionValue: scala.Option[String]
    def licenseManagerReportGeneratorArn: ZIO[Any, Nothing, String] = ZIO.succeed(licenseManagerReportGeneratorArnValue)
    def reportGeneratorName: ZIO[Any, Nothing, primitives.ReportGeneratorName] = ZIO.succeed(reportGeneratorNameValue)
    def `type`: ZIO[Any, Nothing, List[ReportType]] = ZIO.succeed(typeValue)
    def reportContext: ZIO[Any, Nothing, ReportContext.ReadOnly] = ZIO.succeed(reportContextValue)
    def reportFrequency: ZIO[Any, Nothing, ReportFrequency.ReadOnly] = ZIO.succeed(reportFrequencyValue)
    def clientToken: ZIO[Any, Nothing, primitives.ClientRequestToken] = ZIO.succeed(clientTokenValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest) extends UpdateLicenseManagerReportGeneratorRequest.ReadOnly {
    override def licenseManagerReportGeneratorArnValue: String = impl.licenseManagerReportGeneratorArn(): String
    override def reportGeneratorNameValue: primitives.ReportGeneratorName = impl.reportGeneratorName(): primitives.ReportGeneratorName
    override def typeValue: List[ReportType] = impl.`type`().asScala.map { item => 
      ReportType.wrap(item)
    }.toList
    override def reportContextValue: ReportContext.ReadOnly = ReportContext.wrap(impl.reportContext())
    override def reportFrequencyValue: ReportFrequency.ReadOnly = ReportFrequency.wrap(impl.reportFrequency())
    override def clientTokenValue: primitives.ClientRequestToken = impl.clientToken(): primitives.ClientRequestToken
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest): ReadOnly = new Wrapper(impl)
}