package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReportFrequency(value: scala.Option[primitives.Integer] = None, period: scala.Option[ReportFrequencyType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ReportFrequency = {
    import ReportFrequency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ReportFrequency.builder().optionallyWith(value.map(value => value: java.lang.Integer))(_.value).optionallyWith(period.map(value => value.unwrap))(_.period).build()
  }
  def asReadOnly: ReportFrequency.ReadOnly = ReportFrequency.wrap(buildAwsValue())
}
object ReportFrequency {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ReportFrequency] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReportFrequency = ReportFrequency(valueValue.map(value => value), periodValue.map(value => value))
    def valueValue: scala.Option[primitives.Integer]
    def periodValue: scala.Option[ReportFrequencyType]
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
    def period: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReportFrequencyType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("period", periodValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ReportFrequency) extends ReportFrequency.ReadOnly {
    override def valueValue: scala.Option[primitives.Integer] = scala.Option(impl.value()).map(value => value: primitives.Integer)
    override def periodValue: scala.Option[ReportFrequencyType] = scala.Option(impl.period()).map(value => ReportFrequencyType.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ReportFrequency): ReadOnly = new Wrapper(impl)
}