package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RejectGrantRequest(grantArn: primitives.Arn) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest = {
    import RejectGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest.builder().grantArn(grantArn: java.lang.String).build()
  }
  def asReadOnly: RejectGrantRequest.ReadOnly = RejectGrantRequest.wrap(buildAwsValue())
}
object RejectGrantRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RejectGrantRequest = RejectGrantRequest(grantArnValue)
    def grantArnValue: primitives.Arn
    def grantArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(grantArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest) extends RejectGrantRequest.ReadOnly { override def grantArnValue: primitives.Arn = impl.grantArn(): primitives.Arn }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest): ReadOnly = new Wrapper(impl)
}