package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ReceivedStatus { def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus }
object ReceivedStatus {
  def wrap(value: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus): ReceivedStatus = value match {
    case software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.PENDING_WORKFLOW =>
      val r = PENDING_WORKFLOW
      r
    case software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.PENDING_ACCEPT =>
      val r = PENDING_ACCEPT
      r
    case software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.FAILED_WORKFLOW =>
      val r = FAILED_WORKFLOW
      r
    case software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.WORKFLOW_COMPLETED =>
      val r = WORKFLOW_COMPLETED
      r
  }
  case object unknownToSdkVersion extends ReceivedStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus = software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.UNKNOWN_TO_SDK_VERSION }
  case object PENDING_WORKFLOW extends ReceivedStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus = software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.PENDING_WORKFLOW }
  case object PENDING_ACCEPT extends ReceivedStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus = software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.PENDING_ACCEPT }
  case object REJECTED extends ReceivedStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus = software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.REJECTED }
  case object ACTIVE extends ReceivedStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus = software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.ACTIVE }
  case object FAILED_WORKFLOW extends ReceivedStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus = software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.FAILED_WORKFLOW }
  case object DELETED extends ReceivedStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus = software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.DELETED }
  case object DISABLED extends ReceivedStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus = software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.DISABLED }
  case object WORKFLOW_COMPLETED extends ReceivedStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReceivedStatus = software.amazon.awssdk.services.licensemanager.model.ReceivedStatus.WORKFLOW_COMPLETED }
}