package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ProductInformationFilter(productInformationFilterName: String, productInformationFilterValue: scala.Option[Iterable[String]] = None, productInformationFilterComparator: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter = {
    import ProductInformationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter.builder().productInformationFilterName(productInformationFilterName: java.lang.String).optionallyWith(productInformationFilterValue.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.productInformationFilterValue).productInformationFilterComparator(productInformationFilterComparator: java.lang.String).build()
  }
  def asReadOnly: ProductInformationFilter.ReadOnly = ProductInformationFilter.wrap(buildAwsValue())
}
object ProductInformationFilter {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ProductInformationFilter = ProductInformationFilter(productInformationFilterNameValue, productInformationFilterValueValue.map(value => value), productInformationFilterComparatorValue)
    def productInformationFilterNameValue: String
    def productInformationFilterValueValue: scala.Option[List[String]]
    def productInformationFilterComparatorValue: String
    def productInformationFilterName: ZIO[Any, Nothing, String] = ZIO.succeed(productInformationFilterNameValue)
    def productInformationFilterValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productInformationFilterValue", productInformationFilterValueValue)
    def productInformationFilterComparator: ZIO[Any, Nothing, String] = ZIO.succeed(productInformationFilterComparatorValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter) extends ProductInformationFilter.ReadOnly {
    override def productInformationFilterNameValue: String = impl.productInformationFilterName(): String
    override def productInformationFilterValueValue: scala.Option[List[String]] = scala.Option(impl.productInformationFilterValue()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def productInformationFilterComparatorValue: String = impl.productInformationFilterComparator(): String
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter): ReadOnly = new Wrapper(impl)
}