package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ProductInformation(resourceType: String, productInformationFilterList: Iterable[ProductInformationFilter]) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ProductInformation = {
    import ProductInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ProductInformation.builder().resourceType(resourceType: java.lang.String).productInformationFilterList(productInformationFilterList.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: ProductInformation.ReadOnly = ProductInformation.wrap(buildAwsValue())
}
object ProductInformation {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ProductInformation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ProductInformation = ProductInformation(resourceTypeValue, productInformationFilterListValue.map { item => 
      item.editable
    })
    def resourceTypeValue: String
    def productInformationFilterListValue: List[ProductInformationFilter.ReadOnly]
    def resourceType: ZIO[Any, Nothing, String] = ZIO.succeed(resourceTypeValue)
    def productInformationFilterList: ZIO[Any, Nothing, List[ProductInformationFilter.ReadOnly]] = ZIO.succeed(productInformationFilterListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ProductInformation) extends ProductInformation.ReadOnly {
    override def resourceTypeValue: String = impl.resourceType(): String
    override def productInformationFilterListValue: List[ProductInformationFilter.ReadOnly] = impl.productInformationFilterList().asScala.map { item => 
      ProductInformationFilter.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ProductInformation): ReadOnly = new Wrapper(impl)
}