package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListUsageForLicenseConfigurationResponse(licenseConfigurationUsageList: scala.Option[Iterable[LicenseConfigurationUsage]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse = {
    import ListUsageForLicenseConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse.builder().optionallyWith(licenseConfigurationUsageList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenseConfigurationUsageList).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListUsageForLicenseConfigurationResponse.ReadOnly = ListUsageForLicenseConfigurationResponse.wrap(buildAwsValue())
}
object ListUsageForLicenseConfigurationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListUsageForLicenseConfigurationResponse = ListUsageForLicenseConfigurationResponse(licenseConfigurationUsageListValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def licenseConfigurationUsageListValue: scala.Option[List[LicenseConfigurationUsage.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def licenseConfigurationUsageList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LicenseConfigurationUsage.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConfigurationUsageList", licenseConfigurationUsageListValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse) extends ListUsageForLicenseConfigurationResponse.ReadOnly {
    override def licenseConfigurationUsageListValue: scala.Option[List[LicenseConfigurationUsage.ReadOnly]] = scala.Option(impl.licenseConfigurationUsageList()).map(value => value.asScala.map { item => 
      LicenseConfigurationUsage.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse): ReadOnly = new Wrapper(impl)
}