package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTagsForResourceResponse(tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse.builder().optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: ListTagsForResourceResponse.ReadOnly = ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTagsForResourceResponse = ListTagsForResourceResponse(tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse) extends ListTagsForResourceResponse.ReadOnly {
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse): ReadOnly = new Wrapper(impl)
}