package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListLicenseVersionsResponse(licenses: scala.Option[Iterable[License]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse = {
    import ListLicenseVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse.builder().optionallyWith(licenses.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenses).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListLicenseVersionsResponse.ReadOnly = ListLicenseVersionsResponse.wrap(buildAwsValue())
}
object ListLicenseVersionsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListLicenseVersionsResponse = ListLicenseVersionsResponse(licensesValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def licensesValue: scala.Option[List[License.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def licenses: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[License.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenses", licensesValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse) extends ListLicenseVersionsResponse.ReadOnly {
    override def licensesValue: scala.Option[List[License.ReadOnly]] = scala.Option(impl.licenses()).map(value => value.asScala.map { item => 
      License.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse): ReadOnly = new Wrapper(impl)
}