package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListLicenseVersionsRequest(licenseArn: primitives.Arn, nextToken: scala.Option[String] = None, maxResults: scala.Option[primitives.MaxSize100] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest = {
    import ListLicenseVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest.builder().licenseArn(licenseArn: java.lang.String).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListLicenseVersionsRequest.ReadOnly = ListLicenseVersionsRequest.wrap(buildAwsValue())
}
object ListLicenseVersionsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListLicenseVersionsRequest = ListLicenseVersionsRequest(licenseArnValue, nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def licenseArnValue: primitives.Arn
    def nextTokenValue: scala.Option[String]
    def maxResultsValue: scala.Option[primitives.MaxSize100]
    def licenseArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(licenseArnValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxSize100] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest) extends ListLicenseVersionsRequest.ReadOnly {
    override def licenseArnValue: primitives.Arn = impl.licenseArn(): primitives.Arn
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
    override def maxResultsValue: scala.Option[primitives.MaxSize100] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxSize100)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest): ReadOnly = new Wrapper(impl)
}