package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListAssociationsForLicenseConfigurationResponse(licenseConfigurationAssociations: scala.Option[Iterable[LicenseConfigurationAssociation]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse = {
    import ListAssociationsForLicenseConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse.builder().optionallyWith(licenseConfigurationAssociations.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenseConfigurationAssociations).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListAssociationsForLicenseConfigurationResponse.ReadOnly = ListAssociationsForLicenseConfigurationResponse.wrap(buildAwsValue())
}
object ListAssociationsForLicenseConfigurationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListAssociationsForLicenseConfigurationResponse = ListAssociationsForLicenseConfigurationResponse(licenseConfigurationAssociationsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def licenseConfigurationAssociationsValue: scala.Option[List[LicenseConfigurationAssociation.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def licenseConfigurationAssociations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LicenseConfigurationAssociation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConfigurationAssociations", licenseConfigurationAssociationsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse) extends ListAssociationsForLicenseConfigurationResponse.ReadOnly {
    override def licenseConfigurationAssociationsValue: scala.Option[List[LicenseConfigurationAssociation.ReadOnly]] = scala.Option(impl.licenseConfigurationAssociations()).map(value => value.asScala.map { item => 
      LicenseConfigurationAssociation.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse): ReadOnly = new Wrapper(impl)
}