package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LicenseUsage(entitlementUsages: scala.Option[Iterable[EntitlementUsage]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.LicenseUsage = {
    import LicenseUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseUsage.builder().optionallyWith(entitlementUsages.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.entitlementUsages).build()
  }
  def asReadOnly: LicenseUsage.ReadOnly = LicenseUsage.wrap(buildAwsValue())
}
object LicenseUsage {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.LicenseUsage] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LicenseUsage = LicenseUsage(entitlementUsagesValue.map(value => value.map { item => 
      item.editable
    }))
    def entitlementUsagesValue: scala.Option[List[EntitlementUsage.ReadOnly]]
    def entitlementUsages: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[EntitlementUsage.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("entitlementUsages", entitlementUsagesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.LicenseUsage) extends LicenseUsage.ReadOnly {
    override def entitlementUsagesValue: scala.Option[List[EntitlementUsage.ReadOnly]] = scala.Option(impl.entitlementUsages()).map(value => value.asScala.map { item => 
      EntitlementUsage.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.LicenseUsage): ReadOnly = new Wrapper(impl)
}