package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LicenseSpecification(licenseConfigurationArn: String, amiAssociationScope: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.LicenseSpecification = {
    import LicenseSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseSpecification.builder().licenseConfigurationArn(licenseConfigurationArn: java.lang.String).optionallyWith(amiAssociationScope.map(value => value: java.lang.String))(_.amiAssociationScope).build()
  }
  def asReadOnly: LicenseSpecification.ReadOnly = LicenseSpecification.wrap(buildAwsValue())
}
object LicenseSpecification {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.LicenseSpecification] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LicenseSpecification = LicenseSpecification(licenseConfigurationArnValue, amiAssociationScopeValue.map(value => value))
    def licenseConfigurationArnValue: String
    def amiAssociationScopeValue: scala.Option[String]
    def licenseConfigurationArn: ZIO[Any, Nothing, String] = ZIO.succeed(licenseConfigurationArnValue)
    def amiAssociationScope: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amiAssociationScope", amiAssociationScopeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.LicenseSpecification) extends LicenseSpecification.ReadOnly {
    override def licenseConfigurationArnValue: String = impl.licenseConfigurationArn(): String
    override def amiAssociationScopeValue: scala.Option[String] = scala.Option(impl.amiAssociationScope()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.LicenseSpecification): ReadOnly = new Wrapper(impl)
}