package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Issuer(name: String, signKey: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.Issuer = {
    import Issuer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Issuer.builder().name(name: java.lang.String).optionallyWith(signKey.map(value => value: java.lang.String))(_.signKey).build()
  }
  def asReadOnly: Issuer.ReadOnly = Issuer.wrap(buildAwsValue())
}
object Issuer {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.Issuer] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Issuer = Issuer(nameValue, signKeyValue.map(value => value))
    def nameValue: String
    def signKeyValue: scala.Option[String]
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def signKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("signKey", signKeyValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.Issuer) extends Issuer.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def signKeyValue: scala.Option[String] = scala.Option(impl.signKey()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.Issuer): ReadOnly = new Wrapper(impl)
}