package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLicenseUsageRequest(licenseArn: primitives.Arn) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest = {
    import GetLicenseUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest.builder().licenseArn(licenseArn: java.lang.String).build()
  }
  def asReadOnly: GetLicenseUsageRequest.ReadOnly = GetLicenseUsageRequest.wrap(buildAwsValue())
}
object GetLicenseUsageRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLicenseUsageRequest = GetLicenseUsageRequest(licenseArnValue)
    def licenseArnValue: primitives.Arn
    def licenseArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(licenseArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest) extends GetLicenseUsageRequest.ReadOnly { override def licenseArnValue: primitives.Arn = impl.licenseArn(): primitives.Arn }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest): ReadOnly = new Wrapper(impl)
}