package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLicenseRequest(licenseArn: primitives.Arn, version: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest = {
    import GetLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest.builder().licenseArn(licenseArn: java.lang.String).optionallyWith(version.map(value => value: java.lang.String))(_.version).build()
  }
  def asReadOnly: GetLicenseRequest.ReadOnly = GetLicenseRequest.wrap(buildAwsValue())
}
object GetLicenseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLicenseRequest = GetLicenseRequest(licenseArnValue, versionValue.map(value => value))
    def licenseArnValue: primitives.Arn
    def versionValue: scala.Option[String]
    def licenseArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(licenseArnValue)
    def version: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest) extends GetLicenseRequest.ReadOnly {
    override def licenseArnValue: primitives.Arn = impl.licenseArn(): primitives.Arn
    override def versionValue: scala.Option[String] = scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest): ReadOnly = new Wrapper(impl)
}