package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLicenseConfigurationRequest(licenseConfigurationArn: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest = {
    import GetLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest.builder().licenseConfigurationArn(licenseConfigurationArn: java.lang.String).build()
  }
  def asReadOnly: GetLicenseConfigurationRequest.ReadOnly = GetLicenseConfigurationRequest.wrap(buildAwsValue())
}
object GetLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLicenseConfigurationRequest = GetLicenseConfigurationRequest(licenseConfigurationArnValue)
    def licenseConfigurationArnValue: String
    def licenseConfigurationArn: ZIO[Any, Nothing, String] = ZIO.succeed(licenseConfigurationArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest) extends GetLicenseConfigurationRequest.ReadOnly { override def licenseConfigurationArnValue: String = impl.licenseConfigurationArn(): String }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest): ReadOnly = new Wrapper(impl)
}