package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetGrantResponse(grant: scala.Option[Grant] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GetGrantResponse = {
    import GetGrantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetGrantResponse.builder().optionallyWith(grant.map(value => value.buildAwsValue()))(_.grant).build()
  }
  def asReadOnly: GetGrantResponse.ReadOnly = GetGrantResponse.wrap(buildAwsValue())
}
object GetGrantResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GetGrantResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetGrantResponse = GetGrantResponse(grantValue.map(value => value.editable))
    def grantValue: scala.Option[Grant.ReadOnly]
    def grant: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Grant.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("grant", grantValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GetGrantResponse) extends GetGrantResponse.ReadOnly { override def grantValue: scala.Option[Grant.ReadOnly] = scala.Option(impl.grant()).map(value => Grant.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GetGrantResponse): ReadOnly = new Wrapper(impl)
}