package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetGrantRequest(grantArn: primitives.Arn, version: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GetGrantRequest = {
    import GetGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetGrantRequest.builder().grantArn(grantArn: java.lang.String).optionallyWith(version.map(value => value: java.lang.String))(_.version).build()
  }
  def asReadOnly: GetGrantRequest.ReadOnly = GetGrantRequest.wrap(buildAwsValue())
}
object GetGrantRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GetGrantRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetGrantRequest = GetGrantRequest(grantArnValue, versionValue.map(value => value))
    def grantArnValue: primitives.Arn
    def versionValue: scala.Option[String]
    def grantArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(grantArnValue)
    def version: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GetGrantRequest) extends GetGrantRequest.ReadOnly {
    override def grantArnValue: primitives.Arn = impl.grantArn(): primitives.Arn
    override def versionValue: scala.Option[String] = scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GetGrantRequest): ReadOnly = new Wrapper(impl)
}