package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait EntitlementUnit { def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit }
object EntitlementUnit {
  def wrap(value: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit): EntitlementUnit = value match {
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.COUNT =>
      val r = Count
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.SECONDS =>
      val r = Seconds
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MICROSECONDS =>
      val r = Microseconds
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MILLISECONDS =>
      val r = Milliseconds
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.BYTES =>
      val r = Bytes
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.KILOBYTES =>
      val r = Kilobytes
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MEGABYTES =>
      val r = Megabytes
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.GIGABYTES =>
      val r = Gigabytes
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.TERABYTES =>
      val r = Terabytes
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.BITS =>
      val r = Bits
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.KILOBITS =>
      val r = Kilobits
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MEGABITS =>
      val r = Megabits
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.GIGABITS =>
      val r = Gigabits
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.TERABITS =>
      val r = Terabits
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.PERCENT =>
      val r = Percent
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.BYTES_SECOND =>
      val r = `Bytes/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.KILOBYTES_SECOND =>
      val r = `Kilobytes/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MEGABYTES_SECOND =>
      val r = `Megabytes/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.GIGABYTES_SECOND =>
      val r = `Gigabytes/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.TERABYTES_SECOND =>
      val r = `Terabytes/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.BITS_SECOND =>
      val r = `Bits/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.KILOBITS_SECOND =>
      val r = `Kilobits/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MEGABITS_SECOND =>
      val r = `Megabits/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.GIGABITS_SECOND =>
      val r = `Gigabits/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.TERABITS_SECOND =>
      val r = `Terabits/Second`
      r
    case software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.COUNT_SECOND =>
      val r = `Count/Second`
      r
  }
  case object unknownToSdkVersion extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.UNKNOWN_TO_SDK_VERSION }
  case object Count extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.COUNT }
  case object None extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.NONE }
  case object Seconds extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.SECONDS }
  case object Microseconds extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MICROSECONDS }
  case object Milliseconds extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MILLISECONDS }
  case object Bytes extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.BYTES }
  case object Kilobytes extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.KILOBYTES }
  case object Megabytes extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MEGABYTES }
  case object Gigabytes extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.GIGABYTES }
  case object Terabytes extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.TERABYTES }
  case object Bits extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.BITS }
  case object Kilobits extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.KILOBITS }
  case object Megabits extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MEGABITS }
  case object Gigabits extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.GIGABITS }
  case object Terabits extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.TERABITS }
  case object Percent extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.PERCENT }
  case object `Bytes/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.BYTES_SECOND }
  case object `Kilobytes/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.KILOBYTES_SECOND }
  case object `Megabytes/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MEGABYTES_SECOND }
  case object `Gigabytes/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.GIGABYTES_SECOND }
  case object `Terabytes/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.TERABYTES_SECOND }
  case object `Bits/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.BITS_SECOND }
  case object `Kilobits/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.KILOBITS_SECOND }
  case object `Megabits/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.MEGABITS_SECOND }
  case object `Gigabits/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.GIGABITS_SECOND }
  case object `Terabits/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.TERABITS_SECOND }
  case object `Count/Second` extends EntitlementUnit { override def unwrap: software.amazon.awssdk.services.licensemanager.model.EntitlementUnit = software.amazon.awssdk.services.licensemanager.model.EntitlementUnit.COUNT_SECOND }
}