package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Entitlement(name: String, value: scala.Option[String] = None, maxCount: scala.Option[Long] = None, overage: scala.Option[primitives.BoxBoolean] = None, unit: EntitlementUnit, allowCheckIn: scala.Option[primitives.BoxBoolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.Entitlement = {
    import Entitlement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Entitlement.builder().name(name: java.lang.String).optionallyWith(value.map(value => value: java.lang.String))(_.value).optionallyWith(maxCount.map(value => value: java.lang.Long))(_.maxCount).optionallyWith(overage.map(value => value: java.lang.Boolean))(_.overage).unit(unit.unwrap).optionallyWith(allowCheckIn.map(value => value: java.lang.Boolean))(_.allowCheckIn).build()
  }
  def asReadOnly: Entitlement.ReadOnly = Entitlement.wrap(buildAwsValue())
}
object Entitlement {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.Entitlement] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Entitlement = Entitlement(nameValue, valueValue.map(value => value), maxCountValue.map(value => value), overageValue.map(value => value), unitValue, allowCheckInValue.map(value => value))
    def nameValue: String
    def valueValue: scala.Option[String]
    def maxCountValue: scala.Option[Long]
    def overageValue: scala.Option[primitives.BoxBoolean]
    def unitValue: EntitlementUnit
    def allowCheckInValue: scala.Option[primitives.BoxBoolean]
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
    def maxCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxCount", maxCountValue)
    def overage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("overage", overageValue)
    def unit: ZIO[Any, Nothing, EntitlementUnit] = ZIO.succeed(unitValue)
    def allowCheckIn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowCheckIn", allowCheckInValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.Entitlement) extends Entitlement.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def valueValue: scala.Option[String] = scala.Option(impl.value()).map(value => value: String)
    override def maxCountValue: scala.Option[Long] = scala.Option(impl.maxCount()).map(value => value: Long)
    override def overageValue: scala.Option[primitives.BoxBoolean] = scala.Option(impl.overage()).map(value => value: primitives.BoxBoolean)
    override def unitValue: EntitlementUnit = EntitlementUnit.wrap(impl.unit())
    override def allowCheckInValue: scala.Option[primitives.BoxBoolean] = scala.Option(impl.allowCheckIn()).map(value => value: primitives.BoxBoolean)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.Entitlement): ReadOnly = new Wrapper(impl)
}