package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteTokenRequest(tokenId: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest = {
    import DeleteTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest.builder().tokenId(tokenId: java.lang.String).build()
  }
  def asReadOnly: DeleteTokenRequest.ReadOnly = DeleteTokenRequest.wrap(buildAwsValue())
}
object DeleteTokenRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteTokenRequest = DeleteTokenRequest(tokenIdValue)
    def tokenIdValue: String
    def tokenId: ZIO[Any, Nothing, String] = ZIO.succeed(tokenIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest) extends DeleteTokenRequest.ReadOnly { override def tokenIdValue: String = impl.tokenId(): String }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest): ReadOnly = new Wrapper(impl)
}