package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteLicenseConfigurationRequest(licenseConfigurationArn: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest = {
    import DeleteLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest.builder().licenseConfigurationArn(licenseConfigurationArn: java.lang.String).build()
  }
  def asReadOnly: DeleteLicenseConfigurationRequest.ReadOnly = DeleteLicenseConfigurationRequest.wrap(buildAwsValue())
}
object DeleteLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteLicenseConfigurationRequest = DeleteLicenseConfigurationRequest(licenseConfigurationArnValue)
    def licenseConfigurationArnValue: String
    def licenseConfigurationArn: ZIO[Any, Nothing, String] = ZIO.succeed(licenseConfigurationArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest) extends DeleteLicenseConfigurationRequest.ReadOnly { override def licenseConfigurationArnValue: String = impl.licenseConfigurationArn(): String }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest): ReadOnly = new Wrapper(impl)
}