package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLicenseManagerReportGeneratorRequest(reportGeneratorName: primitives.ReportGeneratorName, `type`: Iterable[ReportType], reportContext: ReportContext, reportFrequency: ReportFrequency, clientToken: primitives.ClientRequestToken, description: scala.Option[String] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest = {
    import CreateLicenseManagerReportGeneratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest.builder().reportGeneratorName(reportGeneratorName: java.lang.String).typeWithStrings(`type`.map { item => 
      item.unwrap.toString
    }.asJavaCollection).reportContext(reportContext.buildAwsValue()).reportFrequency(reportFrequency.buildAwsValue()).clientToken(clientToken: java.lang.String).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateLicenseManagerReportGeneratorRequest.ReadOnly = CreateLicenseManagerReportGeneratorRequest.wrap(buildAwsValue())
}
object CreateLicenseManagerReportGeneratorRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLicenseManagerReportGeneratorRequest = CreateLicenseManagerReportGeneratorRequest(reportGeneratorNameValue, typeValue, reportContextValue.editable, reportFrequencyValue.editable, clientTokenValue, descriptionValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def reportGeneratorNameValue: primitives.ReportGeneratorName
    def typeValue: List[ReportType]
    def reportContextValue: ReportContext.ReadOnly
    def reportFrequencyValue: ReportFrequency.ReadOnly
    def clientTokenValue: primitives.ClientRequestToken
    def descriptionValue: scala.Option[String]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def reportGeneratorName: ZIO[Any, Nothing, primitives.ReportGeneratorName] = ZIO.succeed(reportGeneratorNameValue)
    def `type`: ZIO[Any, Nothing, List[ReportType]] = ZIO.succeed(typeValue)
    def reportContext: ZIO[Any, Nothing, ReportContext.ReadOnly] = ZIO.succeed(reportContextValue)
    def reportFrequency: ZIO[Any, Nothing, ReportFrequency.ReadOnly] = ZIO.succeed(reportFrequencyValue)
    def clientToken: ZIO[Any, Nothing, primitives.ClientRequestToken] = ZIO.succeed(clientTokenValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest) extends CreateLicenseManagerReportGeneratorRequest.ReadOnly {
    override def reportGeneratorNameValue: primitives.ReportGeneratorName = impl.reportGeneratorName(): primitives.ReportGeneratorName
    override def typeValue: List[ReportType] = impl.`type`().asScala.map { item => 
      ReportType.wrap(item)
    }.toList
    override def reportContextValue: ReportContext.ReadOnly = ReportContext.wrap(impl.reportContext())
    override def reportFrequencyValue: ReportFrequency.ReadOnly = ReportFrequency.wrap(impl.reportFrequency())
    override def clientTokenValue: primitives.ClientRequestToken = impl.clientToken(): primitives.ClientRequestToken
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest): ReadOnly = new Wrapper(impl)
}