package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLicenseConfigurationRequest(name: String, description: scala.Option[String] = None, licenseCountingType: LicenseCountingType, licenseCount: scala.Option[primitives.BoxLong] = None, licenseCountHardLimit: scala.Option[primitives.BoxBoolean] = None, licenseRules: scala.Option[Iterable[String]] = None, tags: scala.Option[Iterable[Tag]] = None, disassociateWhenNotFound: scala.Option[primitives.BoxBoolean] = None, productInformationList: scala.Option[Iterable[ProductInformation]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest = {
    import CreateLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest.builder().name(name: java.lang.String).optionallyWith(description.map(value => value: java.lang.String))(_.description).licenseCountingType(licenseCountingType.unwrap).optionallyWith(licenseCount.map(value => value: java.lang.Long))(_.licenseCount).optionallyWith(licenseCountHardLimit.map(value => value: java.lang.Boolean))(_.licenseCountHardLimit).optionallyWith(licenseRules.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.licenseRules).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(disassociateWhenNotFound.map(value => value: java.lang.Boolean))(_.disassociateWhenNotFound).optionallyWith(productInformationList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.productInformationList).build()
  }
  def asReadOnly: CreateLicenseConfigurationRequest.ReadOnly = CreateLicenseConfigurationRequest.wrap(buildAwsValue())
}
object CreateLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLicenseConfigurationRequest = CreateLicenseConfigurationRequest(nameValue, descriptionValue.map(value => value), licenseCountingTypeValue, licenseCountValue.map(value => value), licenseCountHardLimitValue.map(value => value), licenseRulesValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), disassociateWhenNotFoundValue.map(value => value), productInformationListValue.map(value => value.map { item => 
      item.editable
    }))
    def nameValue: String
    def descriptionValue: scala.Option[String]
    def licenseCountingTypeValue: LicenseCountingType
    def licenseCountValue: scala.Option[primitives.BoxLong]
    def licenseCountHardLimitValue: scala.Option[primitives.BoxBoolean]
    def licenseRulesValue: scala.Option[List[String]]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def disassociateWhenNotFoundValue: scala.Option[primitives.BoxBoolean]
    def productInformationListValue: scala.Option[List[ProductInformation.ReadOnly]]
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def licenseCountingType: ZIO[Any, Nothing, LicenseCountingType] = ZIO.succeed(licenseCountingTypeValue)
    def licenseCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxLong] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseCount", licenseCountValue)
    def licenseCountHardLimit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseCountHardLimit", licenseCountHardLimitValue)
    def licenseRules: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseRules", licenseRulesValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def disassociateWhenNotFound: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("disassociateWhenNotFound", disassociateWhenNotFoundValue)
    def productInformationList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ProductInformation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productInformationList", productInformationListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest) extends CreateLicenseConfigurationRequest.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def licenseCountingTypeValue: LicenseCountingType = LicenseCountingType.wrap(impl.licenseCountingType())
    override def licenseCountValue: scala.Option[primitives.BoxLong] = scala.Option(impl.licenseCount()).map(value => value: primitives.BoxLong)
    override def licenseCountHardLimitValue: scala.Option[primitives.BoxBoolean] = scala.Option(impl.licenseCountHardLimit()).map(value => value: primitives.BoxBoolean)
    override def licenseRulesValue: scala.Option[List[String]] = scala.Option(impl.licenseRules()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def disassociateWhenNotFoundValue: scala.Option[primitives.BoxBoolean] = scala.Option(impl.disassociateWhenNotFound()).map(value => value: primitives.BoxBoolean)
    override def productInformationListValue: scala.Option[List[ProductInformation.ReadOnly]] = scala.Option(impl.productInformationList()).map(value => value.asScala.map { item => 
      ProductInformation.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest): ReadOnly = new Wrapper(impl)
}