package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateGrantVersionResponse(grantArn: scala.Option[primitives.Arn] = None, status: scala.Option[GrantStatus] = None, version: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse = {
    import CreateGrantVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse.builder().optionallyWith(grantArn.map(value => value: java.lang.String))(_.grantArn).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(version.map(value => value: java.lang.String))(_.version).build()
  }
  def asReadOnly: CreateGrantVersionResponse.ReadOnly = CreateGrantVersionResponse.wrap(buildAwsValue())
}
object CreateGrantVersionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateGrantVersionResponse = CreateGrantVersionResponse(grantArnValue.map(value => value), statusValue.map(value => value), versionValue.map(value => value))
    def grantArnValue: scala.Option[primitives.Arn]
    def statusValue: scala.Option[GrantStatus]
    def versionValue: scala.Option[String]
    def grantArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Arn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("grantArn", grantArnValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, GrantStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def version: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse) extends CreateGrantVersionResponse.ReadOnly {
    override def grantArnValue: scala.Option[primitives.Arn] = scala.Option(impl.grantArn()).map(value => value: primitives.Arn)
    override def statusValue: scala.Option[GrantStatus] = scala.Option(impl.status()).map(value => GrantStatus.wrap(value))
    override def versionValue: scala.Option[String] = scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse): ReadOnly = new Wrapper(impl)
}