package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CheckoutBorrowLicenseResponse(licenseArn: scala.Option[primitives.Arn] = None, licenseConsumptionToken: scala.Option[String] = None, entitlementsAllowed: scala.Option[Iterable[EntitlementData]] = None, nodeId: scala.Option[String] = None, signedToken: scala.Option[primitives.SignedToken] = None, issuedAt: scala.Option[primitives.ISO8601DateTime] = None, expiration: scala.Option[primitives.ISO8601DateTime] = None, checkoutMetadata: scala.Option[Iterable[Metadata]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse = {
    import CheckoutBorrowLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse.builder().optionallyWith(licenseArn.map(value => value: java.lang.String))(_.licenseArn).optionallyWith(licenseConsumptionToken.map(value => value: java.lang.String))(_.licenseConsumptionToken).optionallyWith(entitlementsAllowed.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.entitlementsAllowed).optionallyWith(nodeId.map(value => value: java.lang.String))(_.nodeId).optionallyWith(signedToken.map(value => value: java.lang.String))(_.signedToken).optionallyWith(issuedAt.map(value => value: java.lang.String))(_.issuedAt).optionallyWith(expiration.map(value => value: java.lang.String))(_.expiration).optionallyWith(checkoutMetadata.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.checkoutMetadata).build()
  }
  def asReadOnly: CheckoutBorrowLicenseResponse.ReadOnly = CheckoutBorrowLicenseResponse.wrap(buildAwsValue())
}
object CheckoutBorrowLicenseResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CheckoutBorrowLicenseResponse = CheckoutBorrowLicenseResponse(licenseArnValue.map(value => value), licenseConsumptionTokenValue.map(value => value), entitlementsAllowedValue.map(value => value.map { item => 
      item.editable
    }), nodeIdValue.map(value => value), signedTokenValue.map(value => value), issuedAtValue.map(value => value), expirationValue.map(value => value), checkoutMetadataValue.map(value => value.map { item => 
      item.editable
    }))
    def licenseArnValue: scala.Option[primitives.Arn]
    def licenseConsumptionTokenValue: scala.Option[String]
    def entitlementsAllowedValue: scala.Option[List[EntitlementData.ReadOnly]]
    def nodeIdValue: scala.Option[String]
    def signedTokenValue: scala.Option[primitives.SignedToken]
    def issuedAtValue: scala.Option[primitives.ISO8601DateTime]
    def expirationValue: scala.Option[primitives.ISO8601DateTime]
    def checkoutMetadataValue: scala.Option[List[Metadata.ReadOnly]]
    def licenseArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Arn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def licenseConsumptionToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConsumptionToken", licenseConsumptionTokenValue)
    def entitlementsAllowed: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[EntitlementData.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("entitlementsAllowed", entitlementsAllowedValue)
    def nodeId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nodeId", nodeIdValue)
    def signedToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SignedToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("signedToken", signedTokenValue)
    def issuedAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ISO8601DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("issuedAt", issuedAtValue)
    def expiration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ISO8601DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expiration", expirationValue)
    def checkoutMetadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Metadata.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("checkoutMetadata", checkoutMetadataValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse) extends CheckoutBorrowLicenseResponse.ReadOnly {
    override def licenseArnValue: scala.Option[primitives.Arn] = scala.Option(impl.licenseArn()).map(value => value: primitives.Arn)
    override def licenseConsumptionTokenValue: scala.Option[String] = scala.Option(impl.licenseConsumptionToken()).map(value => value: String)
    override def entitlementsAllowedValue: scala.Option[List[EntitlementData.ReadOnly]] = scala.Option(impl.entitlementsAllowed()).map(value => value.asScala.map { item => 
      EntitlementData.wrap(item)
    }.toList)
    override def nodeIdValue: scala.Option[String] = scala.Option(impl.nodeId()).map(value => value: String)
    override def signedTokenValue: scala.Option[primitives.SignedToken] = scala.Option(impl.signedToken()).map(value => value: primitives.SignedToken)
    override def issuedAtValue: scala.Option[primitives.ISO8601DateTime] = scala.Option(impl.issuedAt()).map(value => value: primitives.ISO8601DateTime)
    override def expirationValue: scala.Option[primitives.ISO8601DateTime] = scala.Option(impl.expiration()).map(value => value: primitives.ISO8601DateTime)
    override def checkoutMetadataValue: scala.Option[List[Metadata.ReadOnly]] = scala.Option(impl.checkoutMetadata()).map(value => value.asScala.map { item => 
      Metadata.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse): ReadOnly = new Wrapper(impl)
}