package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Tag(key: Option[String] = None, value: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Tag
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.Tag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.Tag =
      io.github.vigoo.zioaws.licensemanager.model
        .Tag(keyValue.map(value => value), valueValue.map(value => value))
    def keyValue: Option[String]
    def valueValue: Option[String]
    def key: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", keyValue)
    def value: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.Tag
  ) extends io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly {
    override def keyValue: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override def valueValue: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.Tag
  ): io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly = new Wrapper(
    impl
  )
}
