package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3Location(
    bucket: Option[String] = None,
    keyPrefix: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.S3Location
      .builder()
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(keyPrefix.map(value => value: java.lang.String))(
        _.keyPrefix
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.S3Location.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.S3Location =
      io.github.vigoo.zioaws.licensemanager.model.S3Location(
        bucketValue.map(value => value),
        keyPrefixValue.map(value => value)
      )
    def bucketValue: Option[String]
    def keyPrefixValue: Option[String]
    def bucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucketValue)
    def keyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefixValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.S3Location
  ) extends io.github.vigoo.zioaws.licensemanager.model.S3Location.ReadOnly {
    override def bucketValue: Option[String] =
      scala.Option(impl.bucket()).map(value => value: String)
    override def keyPrefixValue: Option[String] =
      scala.Option(impl.keyPrefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.S3Location
  ): io.github.vigoo.zioaws.licensemanager.model.S3Location.ReadOnly =
    new Wrapper(impl)
}
