package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.StatusReasonMessage
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReceivedMetadata(
    receivedStatus: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReceivedStatus
    ] = None,
    receivedStatusReason: Option[StatusReasonMessage] = None,
    allowedOperations: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata = {
    import ReceivedMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata
      .builder()
      .optionallyWith(receivedStatus.map(value => value.unwrap))(
        _.receivedStatus
      )
      .optionallyWith(
        receivedStatusReason.map(value => value: java.lang.String)
      )(_.receivedStatusReason)
      .optionallyWith(
        allowedOperations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.allowedOperationsWithStrings)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ReceivedMetadata.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ReceivedMetadata
      .wrap(buildAwsValue())
}
object ReceivedMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.ReceivedMetadata =
      io.github.vigoo.zioaws.licensemanager.model.ReceivedMetadata(
        receivedStatusValue.map(value => value),
        receivedStatusReasonValue.map(value => value),
        allowedOperationsValue.map(value => value)
      )
    def receivedStatusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ReceivedStatus]
    def receivedStatusReasonValue: Option[StatusReasonMessage]
    def allowedOperationsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation]
    ]
    def receivedStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ReceivedStatus
    ] = AwsError.unwrapOptionField("receivedStatus", receivedStatusValue)
    def receivedStatusReason: ZIO[Any, AwsError, StatusReasonMessage] = AwsError
      .unwrapOptionField("receivedStatusReason", receivedStatusReasonValue)
    def allowedOperations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
    ]] = AwsError.unwrapOptionField("allowedOperations", allowedOperationsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata
  ) extends io.github.vigoo.zioaws.licensemanager.model.ReceivedMetadata.ReadOnly {
    override def receivedStatusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ReceivedStatus] =
      scala
        .Option(impl.receivedStatus())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.ReceivedStatus.wrap(value)
        )
    override def receivedStatusReasonValue: Option[StatusReasonMessage] = scala
      .Option(impl.receivedStatusReason())
      .map(value => value: StatusReasonMessage)
    override def allowedOperationsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation]
    ] = scala
      .Option(impl.allowedOperations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata
  ): io.github.vigoo.zioaws.licensemanager.model.ReceivedMetadata.ReadOnly =
    new Wrapper(impl)
}
