package io.github.vigoo.zioaws.licensemanager.model
import java.lang.Integer
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxInteger
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProvisionalConfiguration(maxTimeToLiveInMinutes: BoxInteger) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration = {
    import ProvisionalConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration
      .builder()
      .maxTimeToLiveInMinutes(maxTimeToLiveInMinutes: Integer)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration
      .wrap(buildAwsValue())
}
object ProvisionalConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration =
      io.github.vigoo.zioaws.licensemanager.model
        .ProvisionalConfiguration(maxTimeToLiveInMinutesValue)
    def maxTimeToLiveInMinutesValue: BoxInteger
    def maxTimeToLiveInMinutes: ZIO[Any, Nothing, BoxInteger] =
      ZIO.succeed(maxTimeToLiveInMinutesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration
  ) extends io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration.ReadOnly {
    override def maxTimeToLiveInMinutesValue: BoxInteger =
      impl.maxTimeToLiveInMinutes(): BoxInteger
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration
  ): io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration.ReadOnly =
    new Wrapper(impl)
}
