package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Metadata(
    name: Option[String] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.Metadata = {
    import Metadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Metadata
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.Metadata.wrap(buildAwsValue())
}
object Metadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.Metadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.Metadata =
      io.github.vigoo.zioaws.licensemanager.model
        .Metadata(nameValue.map(value => value), valueValue.map(value => value))
    def nameValue: Option[String]
    def valueValue: Option[String]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def value: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.Metadata
  ) extends io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def valueValue: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.Metadata
  ): io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly =
    new Wrapper(impl)
}
