package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxLong
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ManagedResourceSummary(
    resourceType: Option[
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = None,
    associationCount: Option[BoxLong] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary = {
    import ManagedResourceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(associationCount.map(value => value: java.lang.Long))(
        _.associationCount
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary
      .wrap(buildAwsValue())
}
object ManagedResourceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary =
      io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary(
        resourceTypeValue.map(value => value),
        associationCountValue.map(value => value)
      )
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType]
    def associationCountValue: Option[BoxLong]
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def associationCount: ZIO[Any, AwsError, BoxLong] =
      AwsError.unwrapOptionField("associationCount", associationCountValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary
  ) extends io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary.ReadOnly {
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.ResourceType.wrap(value)
        )
    override def associationCountValue: Option[BoxLong] =
      scala.Option(impl.associationCount()).map(value => value: BoxLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary
  ): io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary.ReadOnly =
    new Wrapper(impl)
}
