package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLicenseManagerReportGeneratorsResponse(
    reportGenerators: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.ReportGenerator]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse = {
    import ListLicenseManagerReportGeneratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse
      .builder()
      .optionallyWith(
        reportGenerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reportGenerators)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListLicenseManagerReportGeneratorsResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListLicenseManagerReportGeneratorsResponse
      .wrap(buildAwsValue())
}
object ListLicenseManagerReportGeneratorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListLicenseManagerReportGeneratorsResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .ListLicenseManagerReportGeneratorsResponse(
          reportGeneratorsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def reportGeneratorsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly]
    ]
    def nextTokenValue: Option[String]
    def reportGenerators: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly
    ]] = AwsError.unwrapOptionField("reportGenerators", reportGeneratorsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListLicenseManagerReportGeneratorsResponse.ReadOnly {
    override def reportGeneratorsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly]
    ] = scala
      .Option(impl.reportGenerators())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListLicenseManagerReportGeneratorsResponse.ReadOnly =
    new Wrapper(impl)
}
