package io.github.vigoo.zioaws.licensemanager.model
import java.lang.Integer
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxInteger
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLicenseConversionTasksRequest(
    nextToken: Option[String] = None,
    maxResults: Option[BoxInteger] = None,
    filters: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Filter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksRequest = {
    import ListLicenseConversionTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksRequest
      .wrap(buildAwsValue())
}
object ListLicenseConversionTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .ListLicenseConversionTasksRequest(
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value),
          filtersValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def nextTokenValue: Option[String]
    def maxResultsValue: Option[BoxInteger]
    def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly]
    ]
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, BoxInteger] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksRequest.ReadOnly {
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def maxResultsValue: Option[BoxInteger] =
      scala.Option(impl.maxResults()).map(value => value: BoxInteger)
    override def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Filter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksRequest
  ): io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksRequest.ReadOnly =
    new Wrapper(impl)
}
