package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListFailuresForLicenseConfigurationOperationsResponse(
    licenseOperationFailureList: Option[Iterable[
      io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure
    ]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse = {
    import ListFailuresForLicenseConfigurationOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse
      .builder()
      .optionallyWith(
        licenseOperationFailureList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseOperationFailureList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse
      .wrap(buildAwsValue())
}
object ListFailuresForLicenseConfigurationOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .ListFailuresForLicenseConfigurationOperationsResponse(
          licenseOperationFailureListValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def licenseOperationFailureListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly
    ]]
    def nextTokenValue: Option[String]
    def licenseOperationFailureList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "licenseOperationFailureList",
      licenseOperationFailureListValue
    )
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse.ReadOnly {
    override def licenseOperationFailureListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly
    ]] = scala
      .Option(impl.licenseOperationFailureList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse.ReadOnly =
    new Wrapper(impl)
}
