package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.UsageOperation
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LicenseConversionContext(
    usageOperation: Option[UsageOperation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.LicenseConversionContext = {
    import LicenseConversionContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseConversionContext
      .builder()
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
      .wrap(buildAwsValue())
}
object LicenseConversionContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.LicenseConversionContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext =
      io.github.vigoo.zioaws.licensemanager.model
        .LicenseConversionContext(usageOperationValue.map(value => value))
    def usageOperationValue: Option[UsageOperation]
    def usageOperation: ZIO[Any, AwsError, UsageOperation] =
      AwsError.unwrapOptionField("usageOperation", usageOperationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseConversionContext
  ) extends io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly {
    override def usageOperationValue: Option[UsageOperation] =
      scala.Option(impl.usageOperation()).map(value => value: UsageOperation)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseConversionContext
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly =
    new Wrapper(impl)
}
