package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait LicenseConfigurationStatus {
  def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus
}
object LicenseConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationStatus =
    value match {
      case software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.AVAILABLE =>
        val r = AVAILABLE
        r
      case software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.DISABLED =>
        val r = DISABLED
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus =
      software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus =
      software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.AVAILABLE
  }
  case object DISABLED
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus =
      software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.DISABLED
  }
}
