package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxBoolean
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetServiceSettingsResponse(
    s3BucketArn: Option[String] = None,
    snsTopicArn: Option[String] = None,
    organizationConfiguration: Option[
      io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration
    ] = None,
    enableCrossAccountsDiscovery: Option[BoxBoolean] = None,
    licenseManagerResourceShareArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse = {
    import GetServiceSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse
      .builder()
      .optionallyWith(s3BucketArn.map(value => value: java.lang.String))(
        _.s3BucketArn
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(
        organizationConfiguration.map(value => value.buildAwsValue())
      )(_.organizationConfiguration)
      .optionallyWith(
        enableCrossAccountsDiscovery.map(value => value: java.lang.Boolean)
      )(_.enableCrossAccountsDiscovery)
      .optionallyWith(
        licenseManagerResourceShareArn.map(value => value: java.lang.String)
      )(_.licenseManagerResourceShareArn)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse
      .wrap(buildAwsValue())
}
object GetServiceSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse =
      io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse(
        s3BucketArnValue.map(value => value),
        snsTopicArnValue.map(value => value),
        organizationConfigurationValue.map(value => value.editable),
        enableCrossAccountsDiscoveryValue.map(value => value),
        licenseManagerResourceShareArnValue.map(value => value)
      )
    def s3BucketArnValue: Option[String]
    def snsTopicArnValue: Option[String]
    def organizationConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration.ReadOnly
    ]
    def enableCrossAccountsDiscoveryValue: Option[BoxBoolean]
    def licenseManagerResourceShareArnValue: Option[String]
    def s3BucketArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketArn", s3BucketArnValue)
    def snsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
    def organizationConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationConfiguration",
      organizationConfigurationValue
    )
    def enableCrossAccountsDiscovery: ZIO[Any, AwsError, BoxBoolean] =
      AwsError.unwrapOptionField(
        "enableCrossAccountsDiscovery",
        enableCrossAccountsDiscoveryValue
      )
    def licenseManagerResourceShareArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "licenseManagerResourceShareArn",
        licenseManagerResourceShareArnValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse.ReadOnly {
    override def s3BucketArnValue: Option[String] =
      scala.Option(impl.s3BucketArn()).map(value => value: String)
    override def snsTopicArnValue: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override def organizationConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration.ReadOnly
    ] = scala
      .Option(impl.organizationConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration
          .wrap(value)
      )
    override def enableCrossAccountsDiscoveryValue: Option[BoxBoolean] = scala
      .Option(impl.enableCrossAccountsDiscovery())
      .map(value => value: BoxBoolean)
    override def licenseManagerResourceShareArnValue: Option[String] = scala
      .Option(impl.licenseManagerResourceShareArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse
  ): io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
