package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLicenseResponse(
    license: Option[io.github.vigoo.zioaws.licensemanager.model.License] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse = {
    import GetLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse
      .builder()
      .optionallyWith(license.map(value => value.buildAwsValue()))(_.license)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse
      .wrap(buildAwsValue())
}
object GetLicenseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .GetLicenseResponse(licenseValue.map(value => value.editable))
    def licenseValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly]
    def license: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
    ] = AwsError.unwrapOptionField("license", licenseValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse.ReadOnly {
    override def licenseValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly] =
      scala
        .Option(impl.license())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.License.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse
  ): io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse.ReadOnly =
    new Wrapper(impl)
}
